/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.RenderTypeHandler;
import ichttt.mods.mcpaint.client.render.RenderUtil;
import ichttt.mods.mcpaint.client.render.buffer.BufferManager;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;

public class TERCanvas
extends TileEntityRenderer<TileEntityCanvas> {
    private static final Direction[] VALUES = Direction.values();

    public TERCanvas(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    private static void renderFace(MatrixStack matrix, IVertexBuilder vertexBuilder, TileEntityCanvas te, Direction facing, int light, double playerDistSq) {
        boolean slow;
        boolean xOffset = false;
        boolean yOffset = false;
        boolean zOffset = false;
        int angle = 0;
        double translationXOffset = 0.0;
        double translationYOffset = 0.0;
        double translationZOffset = 0.0;
        switch (facing) {
            case NORTH: {
                angle = 0;
                zOffset = true;
                translationZOffset = 0.0015;
                break;
            }
            case EAST: {
                angle = 270;
                translationXOffset = -0.0015;
                break;
            }
            case SOUTH: {
                angle = 180;
                xOffset = true;
                translationZOffset = -0.0015;
                break;
            }
            case WEST: {
                angle = 90;
                xOffset = true;
                zOffset = true;
                translationXOffset = 0.0015;
                break;
            }
            case UP: {
                xOffset = true;
                zOffset = true;
                translationYOffset = -0.0015;
                break;
            }
            case DOWN: {
                yOffset = true;
                zOffset = true;
                translationYOffset = 0.0015;
            }
        }
        if (playerDistSq < 16.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq < 36.0) {
            translationXOffset /= 4.0;
            translationYOffset /= 4.0;
            translationZOffset /= 4.0;
        }
        if (playerDistSq < 64.0) {
            translationXOffset /= 2.0;
            translationYOffset /= 2.0;
            translationZOffset /= 2.0;
        }
        if (playerDistSq > 256.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 1024.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 4096.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        if (playerDistSq > 9216.0) {
            translationXOffset *= 2.0;
            translationYOffset *= 2.0;
            translationZOffset *= 2.0;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(translationXOffset + (double)xOffset, translationYOffset + (double)yOffset, translationZOffset + (double)zOffset);
        int j = light % 65536;
        int k = light / 65536;
        int maxBrightness = (Integer)MCPaintConfig.CLIENT.maxPaintBrightness.get();
        if (k > maxBrightness) {
            k = maxBrightness;
        }
        if (angle != 0) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle));
        } else if (facing.func_176740_k().func_200128_b()) {
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(facing == Direction.DOWN ? -90.0f : 90.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(facing == Direction.UP ? 180.0f : 0.0f));
        }
        IPaintable paint = te.getPaintFor(facing);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        boolean bl = slow = (Boolean)MCPaintConfig.CLIENT.optimizePictures.get() == false;
        if (!slow) {
            BufferManager builder = te.getBuffer(facing);
            if (builder == null) {
                int maxDistOffset = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get() - 8;
                if (playerDistSq < (double)(maxDistOffset * maxDistOffset)) {
                    slow = true;
                }
            } else {
                builder.get(TERCanvas.getRes(playerDistSq)).renderPicture(matrix4f, vertexBuilder, light);
            }
        }
        if (slow) {
            RenderUtil.renderInGame(matrix4f, paint.getScaleFactor(), vertexBuilder, paint.getPictureData(), light);
        }
        matrix.func_227865_b_();
    }

    public static int getRes(double playerDistSq) {
        if (playerDistSq < 1024.0) {
            return 128;
        }
        if (playerDistSq < 4096.0) {
            return 64;
        }
        if (playerDistSq < 9216.0) {
            return 32;
        }
        if (playerDistSq < 16384.0) {
            return 16;
        }
        return 8;
    }

    public void render(TileEntityCanvas te, float v, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer iRenderTypeBuffer, int light, int otherlight) {
        BlockPos pos = te.func_174877_v();
        double playerDistSq = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        int maxDist = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get();
        IVertexBuilder builder = iRenderTypeBuffer.getBuffer(RenderTypeHandler.CANVAS);
        if (playerDistSq < (double)(maxDist * maxDist)) {
            for (Direction facing : VALUES) {
                if (!te.hasPaintFor(facing)) continue;
                int lightPacked = WorldRenderer.func_228420_a_((IBlockDisplayReader)te.func_145831_w(), (BlockState)te.func_145831_w().func_180495_p(te.func_174877_v()), (BlockPos)te.func_174877_v().func_177972_a(facing.func_176734_d()));
                TERCanvas.renderFace(matrixStack, builder, te, facing, lightPacked, playerDistSq);
            }
        } else {
            te.unbindBuffers();
        }
    }
}

