/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch;

import com.google.common.base.Stopwatch;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.render.OptimizedPictureData;
import ichttt.mods.mcpaint.client.render.OptimizedPictureRenderer;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.LossyCompression;
import ichttt.mods.mcpaint.client.render.batch.pixel.PixelInfo;
import ichttt.mods.mcpaint.client.render.batch.pixel.PixelLine;
import ichttt.mods.mcpaint.client.render.batch.pixel.PixelRect;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PictureCacheBuilder {
    public static OptimizedPictureRenderer batch(int[][] picture, byte scaleFactor, IOptimisationCallback callback, Function<Integer, Boolean> shouldDiscard, int maxTotalVar, int maxSingleVar) {
        Object column;
        if (picture == null) {
            throw new IllegalArgumentException("No paint data");
        }
        if (callback.isInvalid()) {
            return null;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        int pixelsToDraw = 0;
        Int2ObjectOpenHashMap colorMap = new Int2ObjectOpenHashMap();
        for (int x = 0; x < picture.length; ++x) {
            column = picture[x];
            for (int y = 0; y < ((int[])column).length; ++y) {
                int color = column[y];
                int a = color >> 24 & 0xFF;
                if (a <= 2) continue;
                ++pixelsToDraw;
                ((List)colorMap.computeIfAbsent(color, value -> new ArrayList())).add(new PixelInfo(x, y, color));
            }
        }
        if (callback.isInvalid()) {
            return null;
        }
        List<PixelRect> allRects = new ArrayList<PixelRect>();
        column = colorMap.int2ObjectEntrySet().iterator();
        while (column.hasNext()) {
            Object currentPixel22;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)column.next();
            List pixels = (List)entry.getValue();
            ArrayList<PixelLine> lines = new ArrayList<PixelLine>();
            for (Object currentPixel22 : pixels) {
                ArrayList<PixelLine> neighbours = new ArrayList<PixelLine>();
                for (PixelLine pixelLine : lines) {
                    if (!pixelLine.canAdd((PixelInfo)currentPixel22)) continue;
                    neighbours.add(pixelLine);
                }
                if (neighbours.isEmpty()) {
                    lines.add(new PixelLine((PixelInfo)currentPixel22));
                    continue;
                }
                if (neighbours.size() == 1) {
                    ((PixelLine)neighbours.get(0)).add((PixelInfo)currentPixel22);
                    continue;
                }
                PixelLine activeLine = null;
                for (PixelLine infos : neighbours) {
                    if (activeLine == null) {
                        activeLine = infos;
                        activeLine.add((PixelInfo)currentPixel22);
                        continue;
                    }
                    neighbours.remove(infos);
                    activeLine.addAll(infos);
                }
            }
            if (callback.isInvalid()) {
                return null;
            }
            ArrayList<PixelRect> rects = new ArrayList<PixelRect>();
            currentPixel22 = lines.iterator();
            while (currentPixel22.hasNext()) {
                PixelLine line3 = (PixelLine)currentPixel22.next();
                boolean added = false;
                for (PixelRect rect : rects) {
                    if (!rect.addLine(line3)) continue;
                    added = true;
                    break;
                }
                if (added) continue;
                rects.add(new PixelRect(line3));
            }
            allRects.addAll(rects);
        }
        if (callback.isInvalid()) {
            return null;
        }
        int allPixels = 0;
        for (PixelRect rect : allRects) {
            for (PixelLine line : rect) {
                allPixels += line.size();
            }
        }
        if (pixelsToDraw != allPixels) {
            MCPaint.LOGGER.warn("LOST/DUPLICATE INFORMATION!!!!! {} pixels in array, {} in final list", (Object)pixelsToDraw, (Object)allPixels);
            callback.optimizationFailed();
            return null;
        }
        stopwatch.stop();
        MCPaint.LOGGER.info("Merged {} pixels in picture to {} rectangles in {} ms", (Object)pixelsToDraw, (Object)allRects.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        allRects = LossyCompression.colorCompress(maxTotalVar, maxSingleVar, allRects);
        if (shouldDiscard.apply(allRects.size()).booleanValue()) {
            return null;
        }
        List mergedDrawList = allRects.stream().map(PixelRect::getMergedLines).collect(Collectors.toList());
        stopwatch.reset();
        stopwatch.start();
        OptimizedPictureData[] dataArray = new OptimizedPictureData[mergedDrawList.size()];
        for (int i = 0; i < mergedDrawList.size(); ++i) {
            OptimizedPictureData data;
            List infos = (List)mergedDrawList.get(i);
            int left = ((PixelInfo)infos.get((int)0)).x;
            int top = ((PixelInfo)infos.get((int)0)).y;
            int right = ((PixelInfo)infos.get((int)(infos.size() - 1))).x;
            int n = ((PixelInfo)infos.get((int)(infos.size() - 1))).y;
            int color = ((PixelInfo)infos.get((int)0)).drawColor;
            for (PixelInfo info : infos) {
                left = Math.min(left, info.x);
                right = Math.max(right, info.x);
                top = Math.min(top, info.y);
                n = Math.max(n, info.y);
            }
            float leftDraw = (float)(left * scaleFactor) / 128.0f;
            float topDraw = 1.0f - (float)(top * scaleFactor) / 128.0f;
            float rightDraw = (float)((right + 1) * scaleFactor) / 128.0f;
            float bottomDraw = 1.0f - (float)((n + 1) * scaleFactor) / 128.0f;
            dataArray[i] = data = new OptimizedPictureData(color, leftDraw, topDraw, rightDraw, bottomDraw);
        }
        stopwatch.stop();
        MCPaint.LOGGER.debug("Build {} instructions in {} us", (Object)dataArray.length, (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
        return new OptimizedPictureRenderer(dataArray);
    }
}

