/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.render.batch;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.OptimizedPictureRenderer;
import ichttt.mods.mcpaint.client.render.TERCanvas;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.LossyCompression;
import ichttt.mods.mcpaint.client.render.batch.PictureCacheBuilder;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.client.render.buffer.BufferManager;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;

public class PictureOptimizationJob
implements Runnable {
    private final IPaintable paintable;
    private final IOptimisationCallback callback;

    public PictureOptimizationJob(IPaintable paintable, IOptimisationCallback callback) {
        this.paintable = paintable;
        this.callback = callback;
    }

    @Override
    public void run() {
        byte scaleFactor;
        if (this.callback.isInvalid()) {
            return;
        }
        BufferManager cached = RenderCache.getIfPresent(this.paintable);
        if (cached != null) {
            this.callback.provideFinishedBuffer(cached);
            return;
        }
        int[][] pictureData = MCPaintUtil.copyOf(this.paintable.getPictureData());
        OptimizedPictureRenderer renderer = PictureCacheBuilder.batch(pictureData, scaleFactor = this.paintable.getScaleFactor(), this.callback, val -> false, 0, 0);
        if (renderer == null) {
            return;
        }
        int maxMips = (Boolean)MCPaintConfig.CLIENT.enableMipMaps.get() != false ? PictureOptimizationJob.getMaxPass(pictureData.length) : 0;
        BufferManager manager = new BufferManager(renderer, maxMips, pictureData.length);
        this.callback.provideFinishedBuffer(manager);
        if (maxMips > 0) {
            for (int i = 1; i <= maxMips; ++i) {
                int[][] newPicture = LossyCompression.mipMap(pictureData, i);
                byte newScaleFactor = (byte)((double)scaleFactor * Math.pow(2.0, i));
                int currentMip = i;
                renderer = PictureCacheBuilder.batch(newPicture, newScaleFactor, this.callback, val -> manager.needDiscard((int)val, currentMip), (Integer)MCPaintConfig.CLIENT.maxTotalColorDiffPerMip.get() * i, (Integer)MCPaintConfig.CLIENT.maxSingleColorDiffPerMip.get() * i);
                manager.putMips(renderer, i - 1);
            }
        }
        manager.complete();
    }

    private static int getMaxPass(int res) {
        int maxDist = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get();
        int lowestRes = TERCanvas.getRes(maxDist * maxDist);
        int mips = 0;
        while (lowestRes < res) {
            lowestRes *= 2;
            ++mips;
        }
        return mips;
    }
}

