/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.capability;

import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityPaintable {
    @CapabilityInject(value=IPaintable.class)
    public static Capability<IPaintable> PAINTABLE;

    public static void register() {
        CapabilityManager.INSTANCE.register(IPaintable.class, (Capability.IStorage)new Capability.IStorage<IPaintable>(){

            public INBT writeNBT(Capability<IPaintable> capability, IPaintable instance, Direction side) {
                return CapabilityPaintable.writeToNBT(instance, new CompoundNBT());
            }

            public void readNBT(Capability<IPaintable> capability, IPaintable instance, Direction side, INBT nbt) {
                CapabilityPaintable.readFromNBT(instance, (CompoundNBT)nbt);
            }
        }, Paint::new);
    }

    public static CompoundNBT writeToNBT(IPaintable instance, CompoundNBT compound) {
        if (instance.hasPaintData()) {
            short pixelCountX = instance.getPixelCountX();
            byte scaleFactor = instance.getScaleFactor();
            int[][] pictureData = instance.getPictureData();
            compound.func_74777_a("pixelX", pixelCountX);
            compound.func_74774_a("scale", scaleFactor);
            CompoundNBT pictureInfo = new CompoundNBT();
            for (int i = 0; i < pixelCountX / scaleFactor; ++i) {
                pictureInfo.func_74783_a("" + i, pictureData[i]);
            }
            compound.func_218657_a("picture", (INBT)pictureInfo);
            return compound;
        }
        return compound;
    }

    public static void readFromNBT(IPaintable instance, CompoundNBT compound) {
        if (!compound.func_74764_b("scale")) {
            return;
        }
        short pixelCountX = compound.func_74765_d("pixelX");
        byte scaleFactor = compound.func_74771_c("scale");
        CompoundNBT pictureInfo = compound.func_74775_l("picture");
        int arraySize = pixelCountX / scaleFactor;
        int[][] pictureData = new int[arraySize][];
        for (int i = 0; i < arraySize; ++i) {
            pictureData[i] = pictureInfo.func_74759_k("" + i);
        }
        instance.setData(scaleFactor, pictureData, null, null);
    }
}

