/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.helper.GuiRenderHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PickIconScreen
extends Screen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private EditBox textSearch;
    private Button buttonCancel;
    private NonNullList<ItemStack> stacks;
    private int listScrollIndex = 0;

    public PickIconScreen() {
        super((Component)new TranslatableComponent("minemenu.iconScreen.title"));
    }

    public void m_96624_() {
        this.textSearch.m_94120_();
        if (this.textSearch.m_94155_().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(NonNullList<ItemStack> list) {
        list.clear();
        for (Item registryItem : ForgeRegistries.ITEMS) {
            Item item;
            ItemStack stack = new ItemStack((ItemLike)registryItem);
            if (stack.m_41619_() || stack == null || (item = stack.m_41720_()).m_41471_() == null) continue;
            item.m_6787_(item.m_41471_(), list);
        }
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.textSearch;
    }

    public void m_7856_() {
        this.getMinecraft().f_91068_.m_90926_(true);
        this.stacks = NonNullList.m_122779_();
        this.reconstructList(this.stacks);
        this.buttonCancel = new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 60 + 12, 150, 20, (Component)new TranslatableComponent("gui.cancel"), screen -> ScreenStack.pop());
        this.m_142416_((GuiEventListener)this.buttonCancel);
        this.textSearch = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 40, 300, 20, (Component)new TranslatableComponent("minemenu.pickIcon.search"));
        this.textSearch.m_94199_(Short.MAX_VALUE);
        this.textSearch.m_5755_(true);
    }

    public void m_7861_() {
        this.getMinecraft().f_91068_.m_90926_(false);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5534_(char key, int keyCode) {
        block2: {
            NonNullList temp;
            block3: {
                if (!this.textSearch.m_5534_(key, (int)key)) break block2;
                this.listScrollIndex = 0;
                if (this.textSearch.m_94155_().trim().isEmpty()) break block2;
                this.stacks.clear();
                temp = NonNullList.m_122779_();
                if (!this.textSearch.m_94155_().equalsIgnoreCase(".inv")) break block3;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) break block2;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    this.stacks.add((Object)stack.m_41777_());
                }
                break block2;
            }
            this.reconstructList((NonNullList<ItemStack>)temp);
            for (ItemStack stack : temp) {
                if (!stack.m_41786_().getString().toLowerCase().contains(this.textSearch.m_94155_().toLowerCase())) continue;
                this.stacks.add((Object)stack);
            }
        }
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.f_96543_ / 2, this.f_96544_ - (Minecraft.m_91087_().m_91268_().m_85446_() - 80), mouseX, mouseY);
        if (!clicked.m_41619_()) {
            EditSessionData.icon = clicked;
            ScreenStack.pop();
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        this.m_7333_(matrixStack);
        this.textSearch.m_6305_(matrixStack, mouseX, mouseY, partial);
        super.m_6305_(matrixStack, mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(matrixStack, this, 25, 20, 5, "Select an Icon:");
        this.drawList(this.f_96543_ / 2, this.f_96544_ - (Minecraft.m_91087_().m_91268_().m_85446_() - 80), mouseX, mouseY);
    }

    private void drawList(int x, int y, int mx, int my) {
        ItemStack highlighted = ItemStack.f_41583_;
        int highlightedX = 0;
        int highlightedY = 0;
        PoseStack poseStack = RenderSystem.m_157191_();
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) break;
            poseStack.m_85836_();
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (ItemStack)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (!scaled) {
                ItemRenderHelper.renderItem(actualDrawX, actualDrawY, (ItemStack)this.stacks.get(i));
            }
            poseStack.m_85849_();
        }
        if (!highlighted.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            ItemRenderHelper.renderItem(highlightedX, highlightedY, highlighted);
            poseStack.m_85849_();
        }
    }

    @Nonnull
    private ItemStack getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (ItemStack)this.stacks.get(i);
        }
        return ItemStack.f_41583_;
    }
}

