/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import com.mojang.blaze3d.platform.InputConstants;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.RadialMenuScreen;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.KeyReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minemenu", value={Dist.CLIENT})
public class KeyboardHandler {
    public static final KeyboardHandler INSTANCE = new KeyboardHandler();
    private static final KeyMapping WHEEL = new KeyMapping("key.open_menu", 82, "key.categories.misc");
    private static boolean lastWheelState = false;
    private static final List<KeyMapping> FIRED_KEYS = new ArrayList<KeyMapping>();
    private static final List<KeyMapping> TOGGLED_KEYS = new ArrayList<KeyMapping>();
    private static boolean ignoreNextTick = false;

    public static void register() {
        ClientRegistry.registerKeyBinding((KeyMapping)WHEEL);
    }

    private KeyboardHandler() {
    }

    public void fireKey(KeyMapping key) {
        FIRED_KEYS.add(key);
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)true);
        KeyReflectionHelper.setPressTime(key, 1);
        ignoreNextTick = true;
    }

    public void toggleKey(KeyMapping key) {
        if (!TOGGLED_KEYS.contains(key)) {
            TOGGLED_KEYS.add(key);
            KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)true);
            KeyReflectionHelper.setPressTime(key, 1);
        } else {
            TOGGLED_KEYS.remove(key);
            KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)false);
        }
        ignoreNextTick = true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        KeyMapping keyBinding;
        boolean wheelKeyPressed;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long handle = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean bl = wheelKeyPressed = WHEEL.getKey().m_84873_() >= 0 ? InputConstants.m_84830_((long)handle, (int)WHEEL.getKey().m_84873_()) : InputConstants.m_84830_((long)handle, (int)(WHEEL.getKey().m_84873_() + 100));
        if (wheelKeyPressed != lastWheelState) {
            if (((Boolean)ConfigHandler.GENERAL.toggle.get()).booleanValue()) {
                if (wheelKeyPressed) {
                    if (RadialMenuScreen.active) {
                        if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                            RadialMenuScreen.INSTANCE.m_6375_(mc.f_91067_.m_91589_(), mc.f_91067_.m_91594_(), 0);
                        }
                        RadialMenuScreen.deactivate();
                    } else if (mc.f_91080_ == null || mc.f_91080_ instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                }
            } else if (wheelKeyPressed != RadialMenuScreen.active) {
                if (wheelKeyPressed) {
                    if (mc.f_91080_ == null || mc.f_91080_ instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                } else {
                    if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                        RadialMenuScreen.INSTANCE.m_6375_(mc.f_91067_.m_91589_(), mc.f_91067_.m_91594_(), 0);
                    }
                    RadialMenuScreen.deactivate();
                }
            }
        }
        lastWheelState = wheelKeyPressed;
        if (ignoreNextTick) {
            ignoreNextTick = false;
            return;
        }
        Iterator<KeyMapping> iterator = FIRED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            KeyMapping.m_90837_((InputConstants.Key)keyBinding.getKey(), (boolean)false);
            iterator.remove();
        }
        iterator = TOGGLED_KEYS.iterator();
        while (iterator.hasNext()) {
            keyBinding = iterator.next();
            if (!(keyBinding.getKey().m_84873_() < 0 ? InputConstants.m_84830_((long)handle, (int)(keyBinding.getKey().m_84873_() + 100)) : keyBinding.m_90859_()) && mc.f_91080_ == null) continue;
            iterator.remove();
        }
        for (KeyMapping keyBinding2 : TOGGLED_KEYS) {
            KeyReflectionHelper.setPressTime(keyBinding2, 1);
        }
    }
}

