/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.network.packet.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUseItem {
    private int slot;

    public PacketUseItem(int slot) {
        this.slot = slot;
    }

    public static void encode(PacketUseItem pingPacket, FriendlyByteBuf buf) {
        buf.writeInt(pingPacket.slot);
    }

    public static PacketUseItem decode(FriendlyByteBuf buf) {
        return new PacketUseItem(buf.readInt());
    }

    private static EquipmentSlot getSlotFromHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static class Handler {
        public static void handle(PacketUseItem message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player != null) {
                ItemStack slotStack = player.m_150109_().m_8020_(message.slot);
                ItemStack heldSaved = player.m_21205_();
                InteractionHand hand = InteractionHand.MAIN_HAND;
                EquipmentSlot slot = PacketUseItem.getSlotFromHand(hand);
                player.m_8061_(slot, slotStack);
                ItemStack heldItem = player.m_21120_(hand);
                InteractionResultHolder useStack = heldItem.m_41682_(player.f_19853_, (Player)player, hand);
                if (useStack.m_19089_() == InteractionResult.SUCCESS) {
                    player.m_150109_().f_35974_.set(message.slot, (Object)((ItemStack)useStack.m_19095_()));
                }
                player.m_8061_(slot, heldSaved);
                player.f_36095_.m_150429_();
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

