/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu;

import dmillerw.menu.data.json.MenuLoader;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.KeyReflectionHelper;
import dmillerw.menu.network.PacketHandler;
import java.io.File;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="minemenu")
public class MineMenu {
    public static final String MOD_ID = "minemenu";
    public static final String MOD_NAME = "MineMenu";
    public static File menuFolder = new File(FMLPaths.GAMEDIR.get().toFile(), "minemenu");
    public static File menuFile = new File(menuFolder, "menu.json");

    public MineMenu() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupCommon);
        modBus.addListener(EventPriority.LOWEST, this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.spec);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        KeyReflectionHelper.gatherFields();
        PacketHandler.initialize();
    }

    private void setupClient(FMLClientSetupEvent event) {
        if (!menuFolder.exists()) {
            menuFolder.mkdir();
        }
        if (!menuFile.exists()) {
            MenuLoader.save(menuFile);
        }
        event.enqueueWork(() -> MenuLoader.load(menuFile));
    }
}

