/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu.list;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiControlList
extends ContainerObjectSelectionList<KeyBindsList.Entry> {
    public final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.f_96543_, parent.f_96544_, 25, parent.f_96544_ - 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.m_91087_().f_91066_.f_92059_;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.m_90858_();
            if (keybinding.m_90860_().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry(category));
            }
            if ((width = mc.f_91062_.m_92895_(I18n.m_118938_((String)keybinding.m_90860_(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.m_7085_((AbstractSelectionList.Entry)new KeyEntry((KeyMapping)keybinding));
        }
    }

    public int getWidth() {
        return super.getWidth() + 32;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends KeyBindsList.Entry {
        private final String category;
        private final int width;

        CategoryEntry(String category) {
            this.category = I18n.m_118938_((String)category, (Object[])new Object[0]);
            this.width = GuiControlList.this.mc.f_91062_.m_92895_(this.category);
        }

        public void m_6311_(@Nonnull PoseStack matrixStack, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            Font font = GuiControlList.this.mc.f_91062_;
            float f = Objects.requireNonNull(GuiControlList.this.mc.f_91080_).f_96543_ / 2 - this.width / 2;
            Objects.requireNonNull(GuiControlList.this.mc.f_91062_);
            font.m_92883_(matrixStack, this.category, f, (float)(p_230432_3_ + p_230432_6_ - 9 - 1), 0xFFFFFF);
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public boolean m_5755_(boolean changeFocus) {
            return false;
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Nonnull
                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(@Nonnull NarrationElementOutput output) {
                    output.m_169143_(NarratedElementType.TITLE, CategoryEntry.this.category);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping keyBinding;
        private final Component description;
        private final Button buttonSelect;

        KeyEntry(KeyMapping keyBinding) {
            this.keyBinding = keyBinding;
            this.description = Component.m_237115_((String)keyBinding.m_90860_());
            this.buttonSelect = new Button(0, 0, 95, 18, this.description, screen -> {
                ClickActionScreen.keyBinding = keyBinding;
                ScreenStack.pop();
            });
        }

        public void m_6311_(@Nonnull PoseStack matrixStack, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            Font font = GuiControlList.this.mc.f_91062_;
            float f = p_230432_4_ + 90 - GuiControlList.this.maxWidth;
            int n = p_230432_3_ + p_230432_6_ / 2;
            Objects.requireNonNull(GuiControlList.this.mc.f_91062_);
            font.m_92763_(matrixStack, this.description, f, (float)(n - 9 / 2), 0xFFFFFF);
            this.buttonSelect.f_93620_ = p_230432_4_ + 105;
            this.buttonSelect.f_93621_ = p_230432_3_;
            this.buttonSelect.m_93666_(this.keyBinding.m_90863_());
            this.buttonSelect.m_6303_(matrixStack, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean m_6375_(double x, double y, int button) {
            return this.buttonSelect.m_6375_(x, y, button);
        }

        public boolean m_6348_(double x, double y, int button) {
            return this.buttonSelect.m_6348_(x, y, button);
        }
    }
}

