/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dmillerw.menu.data.menu.MenuItem;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.RadialMenuScreen;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.helper.AngleHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="minemenu", value={Dist.CLIENT})
public class ClientTickHandler {
    public static final double ANGLE_PER_ITEM = 36.0;
    private static final double OUTER_RADIUS = 80.0;
    private static final double INNER_RADIUS = 60.0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            RadialMenu.tickTimer();
            Minecraft mc = Minecraft.m_91087_();
            if ((mc.f_91073_ == null || mc.m_91104_()) && RadialMenuScreen.active) {
                RadialMenuScreen.deactivate();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && !mc.f_91066_.f_92062_ && !mc.m_91104_() && RadialMenuScreen.active) {
                ClientTickHandler.renderButtonBackgrounds();
                ClientTickHandler.renderItems();
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent event) {
        if (!(event instanceof RenderGuiOverlayEvent.Post)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && !mc.f_91066_.f_92062_ && !mc.m_91104_() && RadialMenuScreen.active) {
            ClientTickHandler.renderText(event.getPoseStack());
        }
    }

    private static void renderButtonBackgrounds() {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)mc.m_91268_().m_85445_() * 0.5, (double)mc.m_91268_().m_85446_() * 0.5, 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_69464_();
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            float alpha;
            float b;
            float g;
            float r;
            double currAngle = 36.0 * (double)i + 90.0 + 18.0;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            double truecurrAngle = 36.0 * (double)i;
            double truenextAngle = truecurrAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean mouseIn = mouseAngle > truecurrAngle && mouseAngle < truenextAngle;
            currAngle = Math.toRadians(currAngle);
            nextAngle = Math.toRadians(nextAngle);
            double innerRadius = (60.0 - (double)RadialMenu.animationTimer - (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            double outerRadius = (80.0 - (double)RadialMenu.animationTimer + (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            if (mouseIn) {
                r = (float)((Integer)ConfigHandler.VISUAL.selectRed.get()).intValue() / 255.0f;
                g = (float)((Integer)ConfigHandler.VISUAL.selectGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)ConfigHandler.VISUAL.selectBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)ConfigHandler.VISUAL.selectAlpha.get()).intValue() / 255.0f;
            } else {
                r = (float)((Integer)ConfigHandler.VISUAL.menuRed.get()).intValue() / 255.0f;
                g = (float)((Integer)ConfigHandler.VISUAL.menuGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)ConfigHandler.VISUAL.menuBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)ConfigHandler.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            }
            double x1 = Math.cos(currAngle) * innerRadius;
            double x2 = Math.cos(currAngle) * outerRadius;
            double x3 = Math.cos(nextAngle) * outerRadius;
            double x4 = Math.cos(nextAngle) * innerRadius;
            double y1 = Math.sin(currAngle) * innerRadius;
            double y2 = Math.sin(currAngle) * outerRadius;
            double y3 = Math.sin(nextAngle) * outerRadius;
            double y4 = Math.sin(nextAngle) * innerRadius;
            bufferBuilder.m_5483_(x1, y1, 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_(x2, y2, 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_(x3, y3, 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_(x4, y4, 0.0).m_85950_(r, g, b, alpha).m_5752_();
            tessellator.m_85914_();
        }
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static void renderItems() {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)mc.m_91268_().m_85445_() * 0.5, (double)mc.m_91268_().m_85446_() * 0.5, 0.0);
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            Item menuButton = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ConfigHandler.GENERAL.menuButtonIcon.get().toString()));
            ItemStack stack = item != null && !item.icon.m_41619_() ? item.icon : (menuButton == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)menuButton));
            double angle = 36.0 * (double)i;
            double drawOffset = 1.5;
            double drawX = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double drawY = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double length = Math.sqrt(drawX * drawX + drawY * drawY);
            drawX = length * Math.cos(Math.toRadians(angle));
            drawY = length * Math.sin(Math.toRadians(angle));
            ItemRenderHelper.renderItem((int)drawY, (int)drawX, stack);
        }
        poseStack.m_85849_();
    }

    private static void renderText(PoseStack matrixStack) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        Font fontRenderer = mc.f_91062_;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = 360.0 - mouseAngle;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            Object string;
            boolean mouseIn;
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean bl = mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            if (!mouseIn) continue;
            MenuItem item = RadialMenu.getActiveArray()[i];
            Object object = string = item == null ? "Add Item" : item.title;
            if (RadialMenuScreen.m_96638_() && item != null) {
                string = ChatFormatting.RED + "EDIT: " + ChatFormatting.WHITE + (String)string;
            }
            int drawX = window.m_85445_() / 2 - fontRenderer.m_92895_((String)string) / 2;
            int drawY = window.m_85446_() / 2;
            int drawWidth = mc.f_91062_.m_92895_((String)string);
            Objects.requireNonNull(mc.f_91062_);
            int drawHeight = 9;
            float padding = 5.0f;
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float r = (float)((Integer)ConfigHandler.VISUAL.menuRed.get()).intValue() / 255.0f;
            float g = (float)((Integer)ConfigHandler.VISUAL.menuGreen.get()).intValue() / 255.0f;
            float b = (float)((Integer)ConfigHandler.VISUAL.menuBlue.get()).intValue() / 255.0f;
            float alpha = (float)((Integer)ConfigHandler.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            bufferBuilder.m_5483_((double)((float)drawX - padding), (double)((float)(drawY + drawHeight) + padding), 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_((double)((float)(drawX + drawWidth) + padding), (double)((float)(drawY + drawHeight) + padding), 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_((double)((float)(drawX + drawWidth) + padding), (double)((float)drawY - padding), 0.0).m_85950_(r, g, b, alpha).m_5752_();
            bufferBuilder.m_5483_((double)((float)drawX - padding), (double)((float)drawY - padding), 0.0).m_85950_(r, g, b, alpha).m_5752_();
            tessellator.m_85914_();
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            fontRenderer.m_92756_(matrixStack, (String)string, (float)drawX, (float)drawY, 0xFFFFFF, false);
        }
    }
}

