/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import com.mojang.blaze3d.platform.InputConstants;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.gui.RadialMenuScreen;
import dmillerw.menu.handler.ConfigHandler;
import dmillerw.menu.handler.MineMenuKeyMappings;
import dmillerw.menu.helper.KeyReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minemenu", value={Dist.CLIENT})
public class KeyboardHandler {
    public static final KeyboardHandler INSTANCE = new KeyboardHandler();
    private static boolean lastWheelState = false;
    private static final List<KeyMapping> FIRED_KEYS = new ArrayList<KeyMapping>();
    private static boolean ignoreNextTick = false;

    private KeyboardHandler() {
    }

    public void fireKey(KeyMapping keyMapping) {
        FIRED_KEYS.add(keyMapping);
        KeyboardHandler.activateKeybind(keyMapping, true);
        ignoreNextTick = true;
    }

    public void toggleKey(KeyMapping keyMapping) {
        KeyboardHandler.activateKeybind(keyMapping, true);
        ignoreNextTick = true;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean wheelKeyPressed;
        if (event.phase == TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long handle = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean bl = wheelKeyPressed = MineMenuKeyMappings.WHEEL.getKey().m_84873_() >= 0 ? InputConstants.m_84830_((long)handle, (int)MineMenuKeyMappings.WHEEL.getKey().m_84873_()) : InputConstants.m_84830_((long)handle, (int)(MineMenuKeyMappings.WHEEL.getKey().m_84873_() + 100));
        if (wheelKeyPressed != lastWheelState) {
            if (((Boolean)ConfigHandler.GENERAL.toggle.get()).booleanValue()) {
                if (wheelKeyPressed) {
                    if (RadialMenuScreen.active) {
                        if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                            RadialMenuScreen.INSTANCE.m_6375_(mc.f_91067_.m_91589_(), mc.f_91067_.m_91594_(), 0);
                        }
                        RadialMenuScreen.deactivate();
                    } else if (mc.f_91080_ == null || mc.f_91080_ instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                }
            } else if (wheelKeyPressed != RadialMenuScreen.active) {
                if (wheelKeyPressed) {
                    if (mc.f_91080_ == null || mc.f_91080_ instanceof RadialMenuScreen) {
                        RadialMenu.resetCategory();
                        RadialMenu.resetTimer();
                        RadialMenuScreen.activate();
                    }
                } else {
                    if (((Boolean)ConfigHandler.GENERAL.releaseToSelect.get()).booleanValue()) {
                        RadialMenuScreen.INSTANCE.m_6375_(mc.f_91067_.m_91589_(), mc.f_91067_.m_91594_(), 0);
                    }
                    RadialMenuScreen.deactivate();
                }
            }
        }
        lastWheelState = wheelKeyPressed;
        if (ignoreNextTick) {
            ignoreNextTick = false;
            return;
        }
        Iterator<KeyMapping> iterator = FIRED_KEYS.iterator();
        while (iterator.hasNext()) {
            KeyMapping keyBinding = iterator.next();
            KeyboardHandler.activateKeybind(keyBinding, false);
            iterator.remove();
        }
    }

    public static void activateKeybind(KeyMapping keyMapping, boolean setDown) {
        keyMapping.m_7249_(setDown);
        KeyReflectionHelper.setClickCount(keyMapping, 1);
    }
}

