/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dmillerw.menu.data.click.ClickAction;
import dmillerw.menu.data.click.ClickActionCommand;
import dmillerw.menu.data.click.ClickActionKey;
import dmillerw.menu.data.json.ClickActionSerializer;
import dmillerw.menu.data.json.ItemStackSerializer;
import dmillerw.menu.data.menu.MenuItem;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.handler.LogHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class MenuLoader {
    private static final Gson GSON;

    public static void load(File file) {
        try {
            JsonElement element = (JsonElement)GSON.fromJson((Reader)new FileReader(file), JsonElement.class);
            if (!element.isJsonObject()) {
                LogHandler.error("Failed to load menu.json! Improperly formatted file!");
                return;
            }
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                MenuItem[] array = RadialMenu.getArray((String)entry.getKey());
                if (!((JsonElement)entry.getValue()).isJsonObject()) {
                    LogHandler.error(String.format("Failed to load %s category! Improperly formatted!", entry.getKey()));
                    continue;
                }
                for (Map.Entry entry1 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                    String key = (String)entry1.getKey();
                    JsonElement data = (JsonElement)entry1.getValue();
                    try {
                        int id = Integer.valueOf(key);
                        if (id >= 10) continue;
                        array[id] = (MenuItem)GSON.fromJson(data, MenuItem.class);
                        MenuItem item = array[id];
                        if (item.icon.m_41619_()) {
                            MenuItem newItem;
                            LogHandler.warn(String.format("Menu item in slot %s is looking for an item that no longer exists", String.valueOf(id)));
                            array[id] = newItem = new MenuItem(item.title, new ItemStack((ItemLike)Blocks.f_50069_), item.clickAction);
                        }
                        if (item.clickAction == null) {
                            LogHandler.error(String.format("Menu item in slot %s is missing a click action. It will be reset!", String.valueOf(id)));
                            array[id] = null;
                            continue;
                        }
                        if (item.clickAction instanceof ClickActionCommand && ((ClickActionCommand)item.clickAction).command.isEmpty()) {
                            LogHandler.warn(String.format("Menu item in slot %s is defined as a command action, but is missing a command. It will be reset!", String.valueOf(id)));
                            array[id] = null;
                            continue;
                        }
                        if (!(item.clickAction instanceof ClickActionKey) || ((ClickActionKey)item.clickAction).getKeyBinding() != null) continue;
                        LogHandler.warn(String.format("Menu item in slot %s is defined as a key action, but is missing a keybinding. It will be reset!", String.valueOf(id)));
                        array[id] = null;
                    }
                    catch (NumberFormatException ex) {
                        LogHandler.warn("Menu item found with invalid key. Ignoring.");
                    }
                }
                RadialMenu.replaceArray((String)entry.getKey(), array);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void save(File file) {
        if (file.exists()) {
            file.delete();
        }
        JsonObject object = new JsonObject();
        for (String category : RadialMenu.getCategories()) {
            JsonObject object1 = new JsonObject();
            MenuItem[] array = RadialMenu.getArray(category);
            for (int i = 0; i < 10; ++i) {
                if (array[i] == null) continue;
                object1.add(String.valueOf(i), GSON.toJsonTree((Object)array[i]));
            }
            object.add(category, (JsonElement)object1);
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.append(GSON.toJson((JsonElement)object));
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer());
        builder.registerTypeAdapter(ClickAction.IClickAction.class, (Object)new ClickActionSerializer());
        GSON = builder.create();
    }
}

