/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.controlling;

import com.blamejared.controlling.platform.Services;
import com.google.common.collect.ImmutableList;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.ArrayUtils;

public class ControllingGuiControlList
extends ContainerObjectSelectionList<KeyBindsList.Entry> {
    private final Minecraft mc;
    private int maxListLabelWidth;
    public List<KeyBindsList.Entry> allEntries;

    public ControllingGuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.f_96543_, parent.f_96544_, 45, parent.f_96544_ - 25, 20);
        this.mc = mc;
        this.m_6702_().clear();
        this.allEntries = new ArrayList<KeyBindsList.Entry>();
        Object[] bindings = (KeyMapping[])ArrayUtils.clone((Object[])mc.f_91066_.f_92059_);
        Arrays.sort(bindings);
        String lastCategory = null;
        for (Object keybinding : bindings) {
            MutableComponent component;
            int width;
            String category = keybinding.m_90858_();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!category.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry((Component)Component.m_237115_((String)category)));
                }
            }
            if ((width = mc.f_91062_.m_92852_((FormattedText)(component = Component.m_237115_((String)keybinding.m_90860_())))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (category.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding, (Component)component));
        }
    }

    public List<KeyBindsList.Entry> getAllEntries() {
        return this.allEntries;
    }

    protected int addEntry(@Nonnull KeyBindsList.Entry ent) {
        if (this.allEntries == null) {
            this.allEntries = new ArrayList<KeyBindsList.Entry>();
        }
        this.allEntries.add(ent);
        this.m_6702_().add(ent);
        return this.m_6702_().size() - 1;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry {
        private final Component name;
        private final int labelWidth;

        public CategoryEntry(Component name) {
            this.name = name;
            this.labelWidth = ControllingGuiControlList.this.mc.f_91062_.m_92852_((FormattedText)this.name);
        }

        public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.m_280430_(ControllingGuiControlList.this.mc.f_91062_, this.name, Objects.requireNonNull(((ControllingGuiControlList)ControllingGuiControlList.this).f_93386_.f_91080_).f_96543_ / 2 - this.labelWidth / 2, y + rowWidth - 9 - 1, 0xFFFFFF);
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Nonnull
                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(@Nonnull NarrationElementOutput neo) {
                    neo.m_169146_(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        protected void m_264257_() {
        }

        public Component getName() {
            return this.name;
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping key;
        private final Component keyDesc;
        private boolean hasCollision;
        private final Component categoryName;
        private final Button buttonSelect;

        private KeyEntry(KeyMapping key, Component keyDesc) {
            this.key = key;
            this.keyDesc = keyDesc;
            this.categoryName = Component.m_237115_((String)this.key.m_90858_());
            this.buttonSelect = Button.m_253074_((Component)keyDesc, screen -> {
                ClickActionScreen.keyBinding = key;
                ScreenStack.pop();
            }).m_252987_(0, 0, 95, 18).m_253136_();
            this.m_264257_();
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int length = Math.max(0, x + 90 - ControllingGuiControlList.this.maxListLabelWidth);
            guiGraphics.m_280430_(ControllingGuiControlList.this.mc.f_91062_, this.keyDesc, length, y + rowWidth / 2 - 4, 0xFFFFFF);
            this.buttonSelect.m_252865_(x + 105);
            this.buttonSelect.m_253211_(y);
            this.buttonSelect.m_93666_(this.key.m_90863_());
            this.buttonSelect.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.hasCollision) {
                int markerWidth = 3;
                int minX = this.buttonSelect.m_252754_() - 6;
                guiGraphics.m_280509_(minX, y + 2, minX + markerWidth, y + rowWidth + 2, ChatFormatting.RED.m_126665_() | 0xFF000000);
            }
        }

        @Nonnull
        public List<GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.m_6375_(mouseX, mouseY, buttonId);
        }

        public boolean m_6348_(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.m_6348_(mouseX, mouseY, buttonId);
        }

        protected void m_264257_() {
            this.hasCollision = false;
            MutableComponent duplicates = Component.m_237119_();
            if (!this.key.m_90862_()) {
                KeyMapping[] mappings;
                for (KeyMapping mapping : mappings = ((ControllingGuiControlList)ControllingGuiControlList.this).f_93386_.f_91066_.f_92059_) {
                    if ((mapping == this.key || !this.key.m_90850_(mapping)) && !Services.PLATFORM.hasConflictingModifier(this.key, mapping)) continue;
                    if (this.hasCollision) {
                        duplicates.m_130946_(", ");
                    }
                    this.hasCollision = true;
                    duplicates.m_7220_((Component)Component.m_237115_((String)mapping.m_90860_()));
                }
            }
            MutableComponent tooltip = Component.m_237115_((String)this.key.m_90858_());
            if (this.hasCollision) {
                tooltip.m_7220_(CommonComponents.f_178388_);
                tooltip.m_7220_((Component)Component.m_237110_((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicates}));
            }
        }

        public KeyMapping getKey() {
            return this.key;
        }

        public Component getCategoryName() {
            return this.categoryName;
        }

        public Component getKeyDesc() {
            return this.keyDesc;
        }
    }
}

