/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.controlling;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.mojang.blaze3d.platform.InputConstants;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.controlling.ControllingDisplayMode;
import dmillerw.menu.gui.controlling.ControllingGuiControlList;
import dmillerw.menu.gui.controlling.ControllingSortOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.Component;

public class ControllingPickKeyScreen
extends Screen {
    private ControllingGuiControlList controlList;
    private AutoCompletingEditBox<KeyBindsList.Entry> search;
    private ControllingDisplayMode displayMode;
    private ControllingSortOrder sortOrder = ControllingSortOrder.NONE;
    private Button buttonNone;
    private Button buttonSort;
    public static final SearchableType<KeyBindsList.Entry> SEARCHABLE_KEYBINDINGS = new SearchableType.Builder().component(SearchableComponent.create((String)"category", entry -> {
        if (entry instanceof ControllingGuiControlList.CategoryEntry) {
            ControllingGuiControlList.CategoryEntry cat = (ControllingGuiControlList.CategoryEntry)((Object)entry);
            return Optional.of(cat.getName().getString());
        }
        if (entry instanceof ControllingGuiControlList.KeyEntry) {
            ControllingGuiControlList.KeyEntry key = (ControllingGuiControlList.KeyEntry)((Object)entry);
            return Optional.of(key.getCategoryName().getString());
        }
        return Optional.empty();
    })).component(SearchableComponent.create((String)"key", entry -> {
        if (entry instanceof ControllingGuiControlList.KeyEntry) {
            ControllingGuiControlList.KeyEntry key = (ControllingGuiControlList.KeyEntry)((Object)entry);
            return Optional.of(key.getKey().m_90863_().getString());
        }
        return Optional.empty();
    })).defaultComponent(SearchableComponent.create((String)"name", entry -> {
        if (entry instanceof ControllingGuiControlList.KeyEntry) {
            ControllingGuiControlList.KeyEntry key = (ControllingGuiControlList.KeyEntry)((Object)entry);
            return Optional.of(key.getKeyDesc().getString());
        }
        return Optional.empty();
    })).build();
    private final Button.OnPress PRESS_NONE = btn -> {
        if (this.displayMode == ControllingDisplayMode.NONE) {
            this.buttonNone.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = ControllingDisplayMode.ALL;
        } else {
            this.displayMode = ControllingDisplayMode.NONE;
            this.buttonNone.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.m_93666_(this.sortOrder.getDisplay());
        this.filterKeys();
    };

    public ControllingPickKeyScreen() {
        super((Component)Component.m_237115_((String)"mine_menu.keyScreen.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.controlList = new ControllingGuiControlList(this, this.getMinecraft());
        int searchX = this.controlList.m_5759_();
        int btnWidth = 74;
        int groupPadding = 5;
        int centerX = this.f_96543_ / 2;
        int leftX = centerX - 150 - groupPadding;
        int rightX = centerX + groupPadding;
        int bottomY = this.f_96544_ + 1;
        int rowSpacing = 24;
        int topRowY = bottomY - rowSpacing;
        Supplier<List> listSupplier = () -> this.controlList.getAllEntries();
        this.search = (AutoCompletingEditBox)this.m_142416_((GuiEventListener)new AutoCompletingEditBox(this.f_96547_, centerX - searchX / 2, 22, searchX, 20, this.search, (Component)Component.m_237115_((String)"selectWorld.search"), SEARCHABLE_KEYBINDINGS, listSupplier));
        this.search.addResponder(this::filterKeys);
        this.m_169394_((Renderable)this.search.autoComplete());
        this.m_7787_((GuiEventListener)this.controlList);
        this.buttonSort = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.sortOrder.getDisplay(), (Button.OnPress)this.PRESS_SORT).m_252987_(leftX + btnWidth + 2, topRowY, btnWidth, 20).m_253136_());
        this.buttonNone = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (Button.OnPress)this.PRESS_NONE).m_252987_(rightX, topRowY, btnWidth, 20).m_253136_());
        this.displayMode = ControllingDisplayMode.ALL;
        this.m_264313_((GuiEventListener)this.search);
        this.search.m_94188_(0);
        this.m_6702_().sort(Comparator.comparingInt(value -> value.m_264198_().m_274449_()).thenComparingInt(listener -> listener.m_264198_().m_274563_()));
    }

    public boolean m_7043_() {
        return false;
    }

    public void filterKeys() {
        this.filterKeys(this.search.m_94155_());
    }

    public void filterKeys(String lastSearch) {
        this.controlList.m_6702_().clear();
        this.controlList.m_93410_(0.0);
        if (lastSearch.isEmpty() && this.displayMode == ControllingDisplayMode.ALL && this.sortOrder == ControllingSortOrder.NONE) {
            this.controlList.m_6702_().addAll(this.controlList.getAllEntries());
            return;
        }
        Predicate<KeyBindsList.Entry> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        ControllingGuiControlList list = this.controlList;
        if (list != null) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> this.sortOrder.sort((List<KeyBindsList.Entry>)entries);
        }
        list.m_6702_().addAll(SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.m_6702_());
    }

    public void m_86600_() {
        this.search.m_94120_();
    }

    public boolean m_6050_(double xpos, double ypos, double delta) {
        if (this.search.autoComplete().m_6050_(xpos, ypos, delta)) {
            return true;
        }
        return super.m_6050_(xpos, ypos, delta);
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (!this.search.m_93696_() && ControllingPickKeyScreen.m_96637_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)70)) {
            this.search.m_93692_(true);
            return true;
        }
        if (key == 256) {
            ScreenStack.pop();
            this.search.m_93692_(false);
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.controlList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280137_(this.f_96547_, "Select a Key:", this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

