/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.data.json;

import com.girafi.minemenu.data.click.ClickAction;
import com.girafi.minemenu.data.click.ClickActionCategory;
import com.girafi.minemenu.data.click.ClickActionCommand;
import com.girafi.minemenu.data.click.ClickActionKey;
import com.girafi.minemenu.data.click.ClickActionUseItem;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.class_1799;

public class ClickActionSerializer
implements JsonSerializer<ClickAction.IClickAction>,
JsonDeserializer<ClickAction.IClickAction> {
    public JsonElement serialize(ClickAction.IClickAction src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (src instanceof ClickActionCommand) {
            JsonObject commandObject = new JsonObject();
            commandObject.add("command", (JsonElement)new JsonPrimitive(((ClickActionCommand)src).command));
            commandObject.add("clipboard", (JsonElement)new JsonPrimitive(Boolean.valueOf(((ClickActionCommand)src).clipboard)));
            object.add("command", (JsonElement)commandObject);
        } else if (src instanceof ClickActionKey) {
            JsonObject keyObject = new JsonObject();
            keyObject.add("key", (JsonElement)new JsonPrimitive(((ClickActionKey)src).key));
            ClickActionKey cfr_ignored_0 = (ClickActionKey)src;
            keyObject.add("toggle", (JsonElement)new JsonPrimitive(Boolean.valueOf(ClickActionKey.toggle)));
            object.add("key", (JsonElement)keyObject);
        } else if (src instanceof ClickActionUseItem) {
            object.add("item", context.serialize((Object)((ClickActionUseItem)src).stack));
        } else if (src instanceof ClickActionCategory) {
            object.add("category", (JsonElement)new JsonPrimitive(((ClickActionCategory)src).category));
        }
        return object;
    }

    public ClickAction.IClickAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            switch (key) {
                case "command": {
                    if (element.isJsonPrimitive()) {
                        return new ClickActionCommand(element.getAsString(), false);
                    }
                    String command = "";
                    boolean clipboard = false;
                    for (Map.Entry entry1 : element.getAsJsonObject().entrySet()) {
                        if (((String)entry1.getKey()).equals("command")) {
                            command = ((JsonElement)entry1.getValue()).getAsString();
                            continue;
                        }
                        if (!((String)entry1.getKey()).equals("clipboard")) continue;
                        clipboard = ((JsonElement)entry1.getValue()).getAsBoolean();
                    }
                    return new ClickActionCommand(command, clipboard);
                }
                case "key": {
                    if (element.isJsonPrimitive()) {
                        return new ClickActionKey(element.getAsString(), false);
                    }
                    String keybind = "";
                    boolean toggle = false;
                    for (Map.Entry entry1 : element.getAsJsonObject().entrySet()) {
                        if (((String)entry1.getKey()).equals("key")) {
                            keybind = ((JsonElement)entry1.getValue()).getAsString();
                            continue;
                        }
                        if (!((String)entry1.getKey()).equals("toggle")) continue;
                        toggle = ((JsonElement)entry1.getValue()).getAsBoolean();
                    }
                    return new ClickActionKey(keybind, toggle);
                }
                case "item": {
                    return new ClickActionUseItem((class_1799)context.deserialize(element, class_1799.class));
                }
                case "category": {
                    return new ClickActionCategory(element.getAsString());
                }
            }
        }
        return null;
    }
}

