/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.gui.controlling;

import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.platform.Services;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_459;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.apache.commons.lang3.ArrayUtils;

public class ControllingGuiControlList
extends class_4265<class_459.class_461> {
    private final class_310 mc;
    private int maxListLabelWidth;
    public List<class_459.class_461> allEntries;

    public ControllingGuiControlList(class_437 parent, class_310 mc) {
        super(mc, parent.field_22789 + 20, parent.field_22790 - 70, 45, 20);
        this.mc = mc;
        this.method_25396().clear();
        this.allEntries = new ArrayList<class_459.class_461>();
        Object[] bindings = (class_304[])ArrayUtils.clone((Object[])mc.field_1690.field_1839);
        Arrays.sort(bindings);
        String lastCategory = null;
        for (Object keybinding : bindings) {
            class_5250 component;
            int width;
            String category = keybinding.method_1423();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!category.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry((class_2561)class_2561.method_43471((String)category)));
                }
            }
            if ((width = mc.field_1772.method_27525((class_5348)(component = class_2561.method_43471((String)keybinding.method_1431())))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (category.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((class_304)keybinding, (class_2561)component));
        }
    }

    public List<class_459.class_461> getAllEntries() {
        return this.allEntries;
    }

    protected int addEntry(@Nonnull class_459.class_461 ent) {
        if (this.allEntries == null) {
            this.allEntries = new ArrayList<class_459.class_461>();
        }
        this.allEntries.add(ent);
        this.method_25396().add(ent);
        return this.method_25396().size() - 1;
    }

    protected int method_25329() {
        return super.method_25329() + 15 + 20;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    public class CategoryEntry
    extends class_459.class_461
    implements ICategoryEntry {
        private final class_2561 name;
        private final int labelWidth;

        public CategoryEntry(class_2561 name) {
            this.name = name;
            this.labelWidth = ControllingGuiControlList.this.mc.field_1772.method_27525((class_5348)this.name);
        }

        public void method_25343(class_332 guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.method_27535(ControllingGuiControlList.this.mc.field_1772, this.name, Objects.requireNonNull(((ControllingGuiControlList)ControllingGuiControlList.this).field_22740.field_1755).field_22789 / 2 - this.labelWidth / 2, y + rowWidth - 9 - 1, 0xFFFFFF);
        }

        @Nonnull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                @Nonnull
                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(@Nonnull class_6382 neo) {
                    neo.method_37034(class_6381.field_33788, CategoryEntry.this.name);
                }
            });
        }

        @Nonnull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of();
        }

        protected void method_48269() {
        }

        public class_2561 name() {
            return this.name;
        }
    }

    public class KeyEntry
    extends class_459.class_461
    implements IKeyEntry {
        private final class_304 key;
        private final class_2561 keyDesc;
        private boolean hasCollision;
        private final class_2561 categoryName;
        private final class_4185 buttonSelect;

        private KeyEntry(class_304 key, class_2561 keyDesc) {
            this.key = key;
            this.keyDesc = keyDesc;
            this.categoryName = class_2561.method_43471((String)this.key.method_1423());
            this.buttonSelect = class_4185.method_46430((class_2561)keyDesc, screen -> {
                ClickActionScreen.keyBinding = key;
                ScreenStack.pop();
            }).method_46434(0, 0, 95, 18).method_46431();
            this.method_48269();
        }

        public void method_25343(@Nonnull class_332 guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int length = Math.max(0, x + 90 - ControllingGuiControlList.this.maxListLabelWidth);
            guiGraphics.method_27535(ControllingGuiControlList.this.mc.field_1772, this.keyDesc, length, y + rowWidth / 2 - 4, 0xFFFFFF);
            this.buttonSelect.method_46421(x + 105);
            this.buttonSelect.method_46419(y);
            this.buttonSelect.method_25355(this.key.method_16007());
            this.buttonSelect.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.hasCollision) {
                int markerWidth = 3;
                int minX = this.buttonSelect.method_46426() - 6;
                guiGraphics.method_25294(minX, y + 2, minX + markerWidth, y + rowWidth + 2, class_124.field_1061.method_532() | 0xFF000000);
            }
        }

        @Nonnull
        public List<class_364> method_25396() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean method_25402(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.method_25402(mouseX, mouseY, buttonId);
        }

        public boolean method_25406(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.method_25406(mouseX, mouseY, buttonId);
        }

        protected void method_48269() {
            this.hasCollision = false;
            class_5250 duplicates = class_2561.method_43473();
            if (!this.key.method_1415()) {
                class_304[] mappings;
                for (class_304 mapping : mappings = ((ControllingGuiControlList)ControllingGuiControlList.this).field_22740.field_1690.field_1839) {
                    if ((mapping == this.key || !this.key.method_1435(mapping)) && !Services.PLATFORM.hasConflictingModifier(this.key, mapping)) continue;
                    if (this.hasCollision) {
                        duplicates.method_27693(", ");
                    }
                    this.hasCollision = true;
                    duplicates.method_10852((class_2561)class_2561.method_43471((String)mapping.method_1431()));
                }
            }
            class_5250 tooltip = class_2561.method_43471((String)this.key.method_1423());
            if (this.hasCollision) {
                tooltip.method_10852(class_5244.field_33849);
                tooltip.method_10852((class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicates}));
            }
        }

        public class_2561 categoryName() {
            return this.categoryName;
        }

        public class_304 getKey() {
            return this.key;
        }

        public class_2561 getKeyDesc() {
            return this.keyDesc;
        }

        public class_4185 getBtnResetKeyBinding() {
            return null;
        }

        public class_4185 getBtnChangeKeyBinding() {
            return null;
        }
    }
}

