/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.handler;

import com.girafi.minemenu.data.menu.MenuItem;
import com.girafi.minemenu.data.menu.RadialMenu;
import com.girafi.minemenu.gui.RadialMenuScreen;
import com.girafi.minemenu.helper.AngleHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.girafi.minemenu.util.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7923;

public class ClientTickHelper {
    public static final double ANGLE_PER_ITEM = 36.0;
    private static final double OUTER_RADIUS = 80.0;
    private static final double INNER_RADIUS = 60.0;

    public static void renderButtonBackgrounds() {
        class_310 mc = class_310.method_1551();
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_22904((double)mc.method_22683().method_4486() * 0.5, (double)mc.method_22683().method_4502() * 0.5, 0.0);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34540);
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            float alpha;
            float b;
            float g;
            float r;
            double currAngle = 36.0 * (double)i + 90.0 + 18.0;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            double truecurrAngle = 36.0 * (double)i;
            double truenextAngle = truecurrAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean mouseIn = mouseAngle > truecurrAngle && mouseAngle < truenextAngle;
            currAngle = Math.toRadians(currAngle);
            nextAngle = Math.toRadians(nextAngle);
            double innerRadius = (60.0 - (double)RadialMenu.animationTimer - (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            double outerRadius = (80.0 - (double)RadialMenu.animationTimer + (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            if (mouseIn) {
                r = (float)((Integer)Config.VISUAL.selectRed.get()).intValue() / 255.0f;
                g = (float)((Integer)Config.VISUAL.selectGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)Config.VISUAL.selectBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)Config.VISUAL.selectAlpha.get()).intValue() / 255.0f;
            } else {
                r = (float)((Integer)Config.VISUAL.menuRed.get()).intValue() / 255.0f;
                g = (float)((Integer)Config.VISUAL.menuGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)Config.VISUAL.menuBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)Config.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            }
            double x1 = Math.cos(currAngle) * innerRadius;
            double x2 = Math.cos(currAngle) * outerRadius;
            double x3 = Math.cos(nextAngle) * outerRadius;
            double x4 = Math.cos(nextAngle) * innerRadius;
            double y1 = Math.sin(currAngle) * innerRadius;
            double y2 = Math.sin(currAngle) * outerRadius;
            double y3 = Math.sin(nextAngle) * outerRadius;
            double y4 = Math.sin(nextAngle) * innerRadius;
            bufferBuilder.method_22912(x1, y1, 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912(x2, y2, 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912(x3, y3, 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912(x4, y4, 0.0).method_22915(r, g, b, alpha).method_1344();
            tessellator.method_1350();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderItems(class_332 guiGraphics) {
        class_310 mc = class_310.method_1551();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)mc.method_22683().method_4486() * 0.5, (double)mc.method_22683().method_4502() * 0.5, 0.0);
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            class_1792 menuButton = (class_1792)class_7923.field_41178.method_10223(new class_2960((String)Config.GENERAL.menuButtonIcon.get()));
            class_1799 stack = item != null && !item.icon.method_7960() ? item.icon : (menuButton == null ? class_1799.field_8037 : new class_1799((class_1935)menuButton));
            double angle = 36.0 * (double)i;
            double drawOffset = 1.5;
            double drawX = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double drawY = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double length = Math.sqrt(drawX * drawX + drawY * drawY);
            drawX = length * Math.cos(Math.toRadians(angle));
            drawY = length * Math.sin(Math.toRadians(angle));
            ItemRenderHelper.renderItem(guiGraphics, (int)drawY, (int)drawX, stack);
        }
        poseStack.method_22909();
    }

    public static void renderText(class_332 guiGraphics) {
        class_310 mc = class_310.method_1551();
        class_1041 window = mc.method_22683();
        class_327 fontRenderer = mc.field_1772;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = 360.0 - mouseAngle;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            Object string;
            boolean mouseIn;
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean bl = mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            if (!mouseIn) continue;
            MenuItem item = RadialMenu.getActiveArray()[i];
            Object object = string = item == null ? "Add Item" : item.title;
            if (RadialMenuScreen.method_25442() && item != null) {
                string = class_124.field_1061 + "EDIT: " + class_124.field_1068 + (String)string;
            }
            int drawX = window.method_4486() / 2 - fontRenderer.method_1727((String)string) / 2;
            int drawY = window.method_4502() / 2;
            int drawWidth = mc.field_1772.method_1727((String)string);
            Objects.requireNonNull(mc.field_1772);
            int drawHeight = 9;
            float padding = 5.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShader(class_757::method_34540);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            float r = (float)((Integer)Config.VISUAL.menuRed.get()).intValue() / 255.0f;
            float g = (float)((Integer)Config.VISUAL.menuGreen.get()).intValue() / 255.0f;
            float b = (float)((Integer)Config.VISUAL.menuBlue.get()).intValue() / 255.0f;
            float alpha = (float)((Integer)Config.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            bufferBuilder.method_22912((double)((float)drawX - padding), (double)((float)(drawY + drawHeight) + padding), 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912((double)((float)(drawX + drawWidth) + padding), (double)((float)(drawY + drawHeight) + padding), 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912((double)((float)(drawX + drawWidth) + padding), (double)((float)drawY - padding), 0.0).method_22915(r, g, b, alpha).method_1344();
            bufferBuilder.method_22912((double)((float)drawX - padding), (double)((float)drawY - padding), 0.0).method_22915(r, g, b, alpha).method_1344();
            tessellator.method_1350();
            RenderSystem.disableBlend();
            guiGraphics.method_51433(class_310.method_1551().field_1772, (String)string, drawX, drawY, 0xFFFFFF, false);
        }
    }
}

