/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.MineMenuCommon;
import com.girafi.minemenu.data.session.EditSessionData;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class PickIconScreen
extends class_437 {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private class_342 textSearch;
    private class_4185 buttonDone;
    private class_4185 buttonCancel;
    private class_2371<class_1799> stacks;
    private int listScrollIndex = 0;
    private class_1799 iconStack = class_1799.field_8037;

    public PickIconScreen() {
        super((class_2561)class_2561.method_43471((String)"mine_menu.iconScreen.title"));
    }

    public void method_25393() {
        if (this.textSearch.method_1882().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(class_2371<class_1799> list) {
        list.clear();
        for (class_1792 registryItem : class_7923.field_41178) {
            class_1799 stack = new class_1799((class_1935)registryItem);
            if (stack.method_7960() || stack == null) continue;
            list.add((Object)stack);
        }
    }

    public void method_25426() {
        this.stacks = class_2371.method_10211();
        this.reconstructList(this.stacks);
        this.buttonDone = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), screen -> {
            String inputText = this.textSearch.method_1882();
            if (inputText.contains("{")) {
                class_2487 tag = new class_2487();
                try {
                    tag = class_2522.method_10718((String)inputText);
                }
                catch (CommandSyntaxException e) {
                    MineMenuCommon.LOGGER.info("Invalid item NBT");
                    e.printStackTrace();
                }
                class_1799 tagStack = class_1799.method_7915((class_2487)tag);
                EditSessionData.icon = class_1799.method_7915((class_2487)tag);
                if (!tagStack.method_7960() && tagStack != null) {
                    EditSessionData.icon = tagStack;
                    ScreenStack.pop();
                }
            } else {
                class_1792 textItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(inputText));
                if (textItem == class_1802.field_8162 && textItem != null) {
                    MineMenuCommon.LOGGER.warn("Invalid item");
                } else {
                    EditSessionData.icon = new class_1799((class_1935)textItem);
                    ScreenStack.pop();
                }
            }
        }).method_46434(this.field_22789 / 2 - 150, this.field_22790 - 60 + 12, 150, 20).method_46431();
        this.method_37063((class_364)this.buttonDone);
        this.buttonCancel = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), screen -> ScreenStack.pop()).method_46434(this.field_22789 / 2, this.field_22790 - 60 + 12, 150, 20).method_46431();
        this.method_37063((class_364)this.buttonCancel);
        this.textSearch = new class_342(this.field_22793, this.field_22789 / 2 - 150, 40, 300, 20, (class_2561)class_2561.method_43471((String)"mine_menu.pickIcon.search"));
        this.textSearch.method_1880(Short.MAX_VALUE);
        this.textSearch.method_25365(true);
        if (!EditSessionData.icon.method_7960()) {
            if (EditSessionData.icon.method_7985()) {
                this.textSearch.method_1852(EditSessionData.icon.method_7953(EditSessionData.icon.method_7969()).toString());
            } else {
                this.textSearch.method_1852(class_7923.field_41178.method_10221((Object)EditSessionData.icon.method_7909()).toString());
            }
        }
    }

    public void method_25432() {
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25400(char key, int keyCode) {
        if (this.textSearch.method_25400(key, (int)key)) {
            this.listScrollIndex = 0;
            if (!this.textSearch.method_1882().trim().isEmpty()) {
                this.stacks.clear();
                class_2371 temp = class_2371.method_10211();
                if (this.textSearch.method_1882().equalsIgnoreCase(".inv")) {
                    class_746 player = class_310.method_1551().field_1724;
                    if (player != null) {
                        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                            class_1799 stack = player.method_31548().method_5438(i);
                            this.stacks.add((Object)stack.method_7972());
                        }
                    }
                } else {
                    this.reconstructList((class_2371<class_1799>)temp);
                    for (class_1799 stack : temp) {
                        if (!stack.method_7964().getString().toLowerCase().contains(this.textSearch.method_1882().toLowerCase())) continue;
                        this.stacks.add((Object)stack);
                    }
                }
                return true;
            }
            return super.method_25400(key, keyCode);
        }
        return false;
    }

    public boolean method_25404(int keycode, int i2, int i3) {
        if (keycode == 256) {
            ScreenStack.pop();
            return true;
        }
        if (this.textSearch.method_25404(keycode, i2, i3)) {
            return true;
        }
        return super.method_25404(keycode, i2, i3);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        class_1799 clicked = this.getClickedStack(this.field_22789 / 2, this.field_22790 - (class_310.method_1551().method_22683().method_4502() - 80), mouseX, mouseY);
        if (!clicked.method_7960()) {
            this.textSearch.method_1852(class_7923.field_41178.method_10221((Object)clicked.method_7909()).toString());
            this.iconStack = clicked;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double d, double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void method_25394(@Nonnull class_332 guiGraphics, int mouseX, int mouseY, float partial) {
        super.method_25394(guiGraphics, mouseX, mouseY, partial);
        this.textSearch.method_25394(guiGraphics, mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, "Select an Icon:");
        this.drawList(guiGraphics, this.field_22789 / 2, this.field_22790 - (class_310.method_1551().method_22683().method_4502() - 80), mouseX, mouseY);
    }

    private void drawList(class_332 guiGraphics, int x, int y, int mx, int my) {
        class_1799 highlighted = class_1799.field_8037;
        int highlightedX = 0;
        int highlightedY = 0;
        int amountOfRowsThatFits = (this.field_22787.method_22683().method_4502() - 150) / 16;
        amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) break;
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (class_1799)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (scaled) continue;
            ItemRenderHelper.renderItem(guiGraphics, actualDrawX, actualDrawY, (class_1799)this.stacks.get(i));
        }
        if (!highlighted.method_7960()) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            ItemRenderHelper.renderItem(guiGraphics, highlightedX, highlightedY, highlighted);
            poseStack.method_22909();
        }
    }

    @Nonnull
    private class_1799 getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            int amountOfRowsThatFits = (this.field_22787.method_22683().method_4502() - 150) / 16;
            int n = amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (class_1799)this.stacks.get(i);
        }
        return class_1799.field_8037;
    }
}

