/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.data.json;

import com.girafi.minemenu.Constants;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("stack", (JsonElement)new JsonPrimitive(String.valueOf(src.m_41739_(new CompoundTag()))));
        return object;
    }

    @Nonnull
    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return ItemStack.f_41583_;
        }
        CompoundTag stackTag = null;
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!key.equals("stack")) continue;
            try {
                stackTag = TagParser.m_129359_((String)element.getAsString());
            }
            catch (CommandSyntaxException e) {
                Constants.LOG.error((Object)e);
            }
        }
        return stackTag == null ? ItemStack.f_41583_ : ItemStack.m_41712_(stackTag);
    }
}

