/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.util;

import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Visual VISUAL = new Visual(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public ForgeConfigSpec.BooleanValue toggle;
        public ForgeConfigSpec.BooleanValue rightClickToEdit;
        public ForgeConfigSpec.BooleanValue releaseToSelect;
        public ForgeConfigSpec.BooleanValue menuAnimation;
        public ForgeConfigSpec.ConfigValue<String> menuButtonIcon;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.toggle = builder.define("toggle", false);
            this.rightClickToEdit = builder.define("rightClickToEdit", false);
            this.releaseToSelect = builder.define("releaseToSelect", false);
            this.menuAnimation = builder.define("menuAnimation", true);
            this.menuButtonIcon = builder.define("menuButtonIcon", (Object)"minecraft:stone");
            builder.pop();
        }
    }

    public static class Visual {
        public ForgeConfigSpec.IntValue menuAlpha;
        public ForgeConfigSpec.IntValue menuRed;
        public ForgeConfigSpec.IntValue menuGreen;
        public ForgeConfigSpec.IntValue menuBlue;
        public ForgeConfigSpec.IntValue selectAlpha;
        public ForgeConfigSpec.IntValue selectRed;
        public ForgeConfigSpec.IntValue selectGreen;
        public ForgeConfigSpec.IntValue selectBlue;

        Visual(ForgeConfigSpec.Builder builder) {
            builder.push("visual");
            builder.push("menu");
            this.menuAlpha = builder.defineInRange("alpha", 153, 0, 255);
            this.menuRed = builder.defineInRange("red", 0, 0, 255);
            this.menuGreen = builder.defineInRange("green", 0, 0, 255);
            this.menuBlue = builder.defineInRange("blue", 0, 0, 255);
            builder.pop();
            builder.push("select");
            this.selectAlpha = builder.defineInRange("alpha", 153, 0, 255);
            this.selectRed = builder.defineInRange("red", 255, 0, 255);
            this.selectGreen = builder.defineInRange("green", 0, 0, 255);
            this.selectBlue = builder.defineInRange("blue", 0, 0, 255);
            builder.pop();
        }
    }
}

