/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.data.click;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ClickAction {
    COMMAND(false),
    KEYBIND(false),
    ITEM_USE(true),
    CATEGORY(false);

    private final boolean requiresServer;
    private static ClickAction[] clientValues;
    private static ClickAction[] values;

    private ClickAction(boolean requiresServer) {
        this.requiresServer = requiresServer;
    }

    public static List<ClickAction> getClientValues() {
        if (clientValues == null) {
            ArrayList<ClickAction> temp = new ArrayList<ClickAction>();
            for (ClickAction action : ClickAction.getValues()) {
                if (action.requiresServer) continue;
                temp.add(action);
            }
            clientValues = temp.toArray(new ClickAction[temp.size()]);
        }
        return Arrays.asList(clientValues);
    }

    public static List<ClickAction> getValues() {
        if (values == null) {
            values = ClickAction.values();
        }
        return Arrays.asList(values);
    }

    public static interface IClickAction {
        public ClickAction getClickAction();

        public void onClicked();

        public void onRemoved();

        default public boolean deactivates() {
            return false;
        }
    }
}

