/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.data.session.EditSessionData;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PickIconScreen
extends Screen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private EditBox textSearch;
    private Button buttonCancel;
    private NonNullList<ItemStack> stacks;
    private int listScrollIndex = 0;

    public PickIconScreen() {
        super((Component)Component.m_237115_((String)"mine_menu.iconScreen.title"));
    }

    public void m_86600_() {
        if (this.textSearch.m_94155_().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(NonNullList<ItemStack> list) {
        list.clear();
        for (Item registryItem : BuiltInRegistries.f_257033_) {
            ItemStack stack = new ItemStack((ItemLike)registryItem);
            if (stack.m_41619_() || stack == null) continue;
            list.add((Object)stack);
        }
    }

    public void m_7856_() {
        this.stacks = NonNullList.m_122779_();
        this.reconstructList(this.stacks);
        this.buttonCancel = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), screen -> ScreenStack.pop()).m_252987_(this.f_96543_ / 2 - 75, this.f_96544_ - 60 + 12, 150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.buttonCancel);
        this.textSearch = new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 40, 300, 20, (Component)Component.m_237115_((String)"mine_menu.pickIcon.search"));
        this.textSearch.m_94199_(Short.MAX_VALUE);
        this.textSearch.m_93692_(true);
        this.m_264313_((GuiEventListener)this.textSearch);
    }

    public void m_7861_() {
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5534_(char key, int keyCode) {
        if (this.textSearch.m_5534_(key, (int)key)) {
            this.listScrollIndex = 0;
            if (!this.textSearch.m_94155_().trim().isEmpty()) {
                this.stacks.clear();
                NonNullList temp = NonNullList.m_122779_();
                if (this.textSearch.m_94155_().equalsIgnoreCase(".inv")) {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player != null) {
                        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                            ItemStack stack = player.m_150109_().m_8020_(i);
                            this.stacks.add((Object)stack.m_41777_());
                        }
                    }
                } else {
                    this.reconstructList((NonNullList<ItemStack>)temp);
                    for (ItemStack stack : temp) {
                        if (!stack.m_41786_().getString().toLowerCase().contains(this.textSearch.m_94155_().toLowerCase())) continue;
                        this.stacks.add((Object)stack);
                    }
                }
                return true;
            }
            return super.m_5534_(key, keyCode);
        }
        return false;
    }

    public boolean m_7933_(int keycode, int i2, int i3) {
        if (keycode == 256) {
            ScreenStack.pop();
            return true;
        }
        if (this.textSearch.m_7933_(keycode, i2, i3)) {
            return true;
        }
        return super.m_7933_(keycode, i2, i3);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.f_96543_ / 2, this.f_96544_ - (Minecraft.m_91087_().m_91268_().m_85446_() - 80), mouseX, mouseY);
        if (!clicked.m_41619_()) {
            EditSessionData.icon = clicked;
            ScreenStack.pop();
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double d, double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.textSearch.m_88315_(guiGraphics, mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, "Select an Icon:");
        this.drawList(guiGraphics, this.f_96543_ / 2, this.f_96544_ - (Minecraft.m_91087_().m_91268_().m_85446_() - 80), mouseX, mouseY);
    }

    private void drawList(GuiGraphics guiGraphics, int x, int y, int mx, int my) {
        ItemStack highlighted = ItemStack.f_41583_;
        int highlightedX = 0;
        int highlightedY = 0;
        int amountOfRowsThatFits = (this.f_96541_.m_91268_().m_85446_() - 150) / 16;
        amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) break;
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (ItemStack)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (scaled) continue;
            ItemRenderHelper.renderItem(guiGraphics, actualDrawX, actualDrawY, (ItemStack)this.stacks.get(i));
        }
        if (!highlighted.m_41619_()) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            ItemRenderHelper.renderItem(guiGraphics, highlightedX, highlightedY, highlighted);
            poseStack.m_85849_();
        }
    }

    @Nonnull
    private ItemStack getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            int amountOfRowsThatFits = (this.f_96541_.m_91268_().m_85446_() - 150) / 16;
            int n = amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (ItemStack)this.stacks.get(i);
        }
        return ItemStack.f_41583_;
    }
}

