/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu.list;

import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class GuiControlList
extends ContainerObjectSelectionList<KeyBindsList.Entry> {
    public final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.f_96543_ + 32, parent.f_96544_ - 20, 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.m_91087_().f_91066_.f_92059_;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.m_90858_();
            if (keybinding.m_90860_().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)category)));
            }
            if ((width = mc.f_91062_.m_92895_(I18n.m_118938_((String)keybinding.m_90860_(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.m_7085_((AbstractSelectionList.Entry)new KeyEntry((KeyMapping)keybinding));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry {
        final Component name;
        private final int width;

        public CategoryEntry(Component name) {
            this.name = name;
            this.width = GuiControlList.this.mc.f_91062_.m_92852_((FormattedText)this.name);
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int slotIndex, int x, int y, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = GuiControlList.this.mc.f_91062_;
            int n = Objects.requireNonNull(GuiControlList.this.mc.f_91080_).f_96543_ / 2 - this.width / 2;
            Objects.requireNonNull(GuiControlList.this.mc.f_91062_);
            guiGraphics.m_280430_(font, this.name, n, x + rowWidth - 9 - 1, 0xFFFFFF);
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Nonnull
                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(@Nonnull NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        protected void m_264257_() {
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping key;
        private final Component name;
        private final Button buttonSelect;

        KeyEntry(KeyMapping keyBinding) {
            this.key = keyBinding;
            this.name = Component.m_237115_((String)keyBinding.m_90860_());
            this.buttonSelect = Button.m_253074_((Component)this.name, screen -> {
                ClickActionScreen.keyBinding = keyBinding;
                ScreenStack.pop();
            }).m_252987_(0, 0, 95, 18).m_253136_();
            this.m_264257_();
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int slotIndex, int x, int y, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = GuiControlList.this.mc.f_91062_;
            int n = y + 90 - GuiControlList.this.maxWidth;
            int n2 = x + rowWidth / 2;
            Objects.requireNonNull(GuiControlList.this.mc.f_91062_);
            guiGraphics.m_280430_(font, this.name, n, n2 - 9 / 2, 0xFFFFFF);
            this.buttonSelect.m_252865_(y + 105);
            this.buttonSelect.m_253211_(x);
            this.buttonSelect.m_93666_(this.key.m_90863_());
            this.buttonSelect.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Nonnull
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean m_6375_(double x, double y, int button) {
            return this.buttonSelect.m_6375_(x, y, button);
        }

        public boolean m_6348_(double x, double y, int button) {
            return this.buttonSelect.m_6348_(x, y, button);
        }

        protected void m_264257_() {
            this.buttonSelect.m_93666_(this.key.m_90863_());
            MutableComponent mutablecomponent = Component.m_237119_();
            if (!this.key.m_90862_()) {
                for (KeyMapping keymapping : ((GuiControlList)GuiControlList.this).f_93386_.f_91066_.f_92059_) {
                    if (keymapping == this.key || !this.key.m_90850_(keymapping)) continue;
                    mutablecomponent.m_7220_((Component)Component.m_237115_((String)keymapping.m_90860_()));
                }
            }
        }

        public KeyMapping getKey() {
            return this.key;
        }
    }
}

