/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.network.packet.server;

import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PacketUseItem {
    public static final ResourceLocation CHANNEL = new ResourceLocation("minemenu", "packet_use_item");
    private int slot;

    public PacketUseItem(int slot) {
        this.slot = slot;
    }

    public static void encode(PacketUseItem pingPacket, FriendlyByteBuf buf) {
        buf.writeInt(pingPacket.slot);
    }

    public static PacketUseItem decode(FriendlyByteBuf buf) {
        return new PacketUseItem(buf.readInt());
    }

    public static void handle(PacketContext<PacketUseItem> ctx) {
        ServerPlayer player = ctx.sender();
        if (player != null) {
            InteractionResult use;
            ItemStack slotStack = player.m_150109_().m_8020_(((PacketUseItem)ctx.message()).slot);
            ItemStack heldSaved = player.m_21205_();
            InteractionHand hand = InteractionHand.MAIN_HAND;
            EquipmentSlot slot = PacketUseItem.getSlotFromHand(hand);
            player.m_8061_(slot, slotStack);
            ItemStack heldItem = player.m_21120_(hand);
            UseOnContext useOnContext = new UseOnContext((Player)player, hand, PacketUseItem.getPlayerPOVHitResult(player.m_9236_(), (Player)player, ClipContext.Fluid.SOURCE_ONLY));
            if (heldItem.m_41661_(useOnContext) == InteractionResult.PASS && (use = heldItem.m_41682_(player.m_9236_(), (Player)player, hand).m_19089_()).m_19077_() && heldItem.m_41720_() instanceof BucketItem) {
                player.m_150109_().f_35974_.set(((PacketUseItem)ctx.message()).slot, (Object)new ItemStack((ItemLike)Items.f_42446_));
            }
            player.m_8061_(slot, heldSaved);
            player.f_36095_.m_150429_();
        }
    }

    public static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        float f = p_41437_.m_146909_();
        float f1 = p_41437_.m_146908_();
        Vec3 vec3 = p_41437_.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = 4.5;
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_41436_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    public static EquipmentSlot getSlotFromHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }
}

