/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.data.click;

import com.girafi.minemenu.data.click.ClickAction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class ClickActionCommand
implements ClickAction.IClickAction {
    public final String command;
    public boolean clipboard;

    public ClickActionCommand(String command, boolean clipboard) {
        this.command = command;
        this.clipboard = clipboard;
    }

    @Override
    public ClickAction getClickAction() {
        return ClickAction.COMMAND;
    }

    @Override
    public void onClicked() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            String parsedCommand = this.command.replace("@p", player.getName().getString());
            if (this.clipboard) {
                mc.keyboardHandler.setClipboard(parsedCommand);
                player.displayClientMessage((Component)Component.translatable((String)"mine_menu.clipboardCopy"), true);
            } else {
                parsedCommand = parsedCommand.startsWith("//") ? parsedCommand.replace("//", "/") : parsedCommand.replaceAll("^/+", "");
                player.connection.sendUnsignedCommand(parsedCommand);
            }
        }
    }

    @Override
    public void onRemoved() {
    }
}

