/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.handler;

import com.girafi.minemenu.data.menu.MenuItem;
import com.girafi.minemenu.data.menu.RadialMenu;
import com.girafi.minemenu.gui.RadialMenuScreen;
import com.girafi.minemenu.helper.AngleHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.girafi.minemenu.util.Config;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ClientTickHelper {
    public static final double ANGLE_PER_ITEM = 36.0;
    private static final double OUTER_RADIUS = 80.0;
    private static final double INNER_RADIUS = 60.0;

    public static void renderButtonBackgrounds() {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushPose();
        poseStack.translate((double)mc.getWindow().getGuiScaledWidth() * 0.5, (double)mc.getWindow().getGuiScaledHeight() * 0.5, 0.0);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            float alpha;
            float b;
            float g;
            float r;
            double currAngle = 36.0 * (double)i + 90.0 + 18.0;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            double truecurrAngle = 36.0 * (double)i;
            double truenextAngle = truecurrAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean mouseIn = mouseAngle > truecurrAngle && mouseAngle < truenextAngle;
            currAngle = Math.toRadians(currAngle);
            nextAngle = Math.toRadians(nextAngle);
            double innerRadius = (60.0 - (double)RadialMenu.animationTimer - (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            double outerRadius = (80.0 - (double)RadialMenu.animationTimer + (double)(mouseIn ? 2 : 0)) / 100.0 * 130.0;
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            if (mouseIn) {
                r = (float)((Integer)Config.VISUAL.selectRed.get()).intValue() / 255.0f;
                g = (float)((Integer)Config.VISUAL.selectGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)Config.VISUAL.selectBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)Config.VISUAL.selectAlpha.get()).intValue() / 255.0f;
            } else {
                r = (float)((Integer)Config.VISUAL.menuRed.get()).intValue() / 255.0f;
                g = (float)((Integer)Config.VISUAL.menuGreen.get()).intValue() / 255.0f;
                b = (float)((Integer)Config.VISUAL.menuBlue.get()).intValue() / 255.0f;
                alpha = (float)((Integer)Config.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            }
            double x1 = Math.cos(currAngle) * innerRadius;
            double x2 = Math.cos(currAngle) * outerRadius;
            double x3 = Math.cos(nextAngle) * outerRadius;
            double x4 = Math.cos(nextAngle) * innerRadius;
            double y1 = Math.sin(currAngle) * innerRadius;
            double y2 = Math.sin(currAngle) * outerRadius;
            double y3 = Math.sin(nextAngle) * outerRadius;
            double y4 = Math.sin(nextAngle) * innerRadius;
            bufferBuilder.vertex(x1, y1, 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex(x2, y2, 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex(x3, y3, 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex(x4, y4, 0.0).color(r, g, b, alpha).endVertex();
            tessellator.end();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)mc.getWindow().getGuiScaledWidth() * 0.5, (double)mc.getWindow().getGuiScaledHeight() * 0.5, 0.0);
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            Item menuButton = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation((String)Config.GENERAL.menuButtonIcon.get()));
            ItemStack stack = item != null && !item.icon.isEmpty() ? item.icon : (menuButton == null ? ItemStack.EMPTY : new ItemStack((ItemLike)menuButton));
            double angle = 36.0 * (double)i;
            double drawOffset = 1.5;
            double drawX = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double drawY = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double length = Math.sqrt(drawX * drawX + drawY * drawY);
            drawX = length * Math.cos(Math.toRadians(angle));
            drawY = length * Math.sin(Math.toRadians(angle));
            ItemRenderHelper.renderItem(guiGraphics, (int)drawY, (int)drawX, stack);
        }
        poseStack.popPose();
    }

    public static void renderText(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        Font fontRenderer = mc.font;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = 360.0 - mouseAngle;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            Object string;
            boolean mouseIn;
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean bl = mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            if (!mouseIn) continue;
            MenuItem item = RadialMenu.getActiveArray()[i];
            Object object = string = item == null ? "Add Item" : item.title;
            if (RadialMenuScreen.hasShiftDown() && item != null) {
                string = ChatFormatting.RED + "EDIT: " + ChatFormatting.WHITE + (String)string;
            }
            int drawX = window.getGuiScaledWidth() / 2 - fontRenderer.width((String)string) / 2;
            int drawY = window.getGuiScaledHeight() / 2;
            int drawWidth = mc.font.width((String)string);
            Objects.requireNonNull(mc.font);
            int drawHeight = 9;
            float padding = 5.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = tessellator.getBuilder();
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            float r = (float)((Integer)Config.VISUAL.menuRed.get()).intValue() / 255.0f;
            float g = (float)((Integer)Config.VISUAL.menuGreen.get()).intValue() / 255.0f;
            float b = (float)((Integer)Config.VISUAL.menuBlue.get()).intValue() / 255.0f;
            float alpha = (float)((Integer)Config.VISUAL.menuAlpha.get()).intValue() / 255.0f;
            bufferBuilder.vertex((double)((float)drawX - padding), (double)((float)(drawY + drawHeight) + padding), 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex((double)((float)(drawX + drawWidth) + padding), (double)((float)(drawY + drawHeight) + padding), 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex((double)((float)(drawX + drawWidth) + padding), (double)((float)drawY - padding), 0.0).color(r, g, b, alpha).endVertex();
            bufferBuilder.vertex((double)((float)drawX - padding), (double)((float)drawY - padding), 0.0).color(r, g, b, alpha).endVertex();
            tessellator.end();
            RenderSystem.disableBlend();
            guiGraphics.drawString(Minecraft.getInstance().font, (String)string, drawX, drawY, 0xFFFFFF, false);
        }
    }
}

