/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PickItemScreen
extends Screen {
    private static final int XSIZE = 176;
    private static final int YSIZE = 166;
    private int guiLeft;
    private int guiTop;

    public PickItemScreen() {
        super((Component)Component.translatable((String)"mine_menu.itemScreen.title"));
    }

    public void init() {
        super.init();
        this.guiLeft = (this.width - 176) / 2;
        this.guiTop = (this.height - 166) / 2;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Minecraft mc = this.minecraft;
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, "Pick an Item:");
        guiGraphics.blit(new ResourceLocation("textures/gui/container/inventory.png"), this.guiLeft, this.guiTop, 0, 0, 176, 166);
        Slot mousedOver = null;
        if (mc != null && mc.player != null) {
            for (int i1 = 0; i1 < mc.player.inventoryMenu.slots.size(); ++i1) {
                Slot slot = (Slot)mc.player.inventoryMenu.slots.get(i1);
                if (mouseX - this.guiLeft >= slot.x && mouseX - this.guiLeft <= slot.x + 16 && mouseY - this.guiTop >= slot.y && mouseY - this.guiTop <= slot.y + 16) {
                    mousedOver = slot;
                    continue;
                }
                this.drawSlot(guiGraphics, slot, false);
            }
            if (mousedOver != null && !mousedOver.getItem().isEmpty()) {
                this.drawSlot(guiGraphics, mousedOver, true);
                guiGraphics.renderTooltip(this.font, mousedOver.getItem(), mouseX, mouseY);
            }
        }
    }

    private void drawSlot(@Nonnull GuiGraphics guiGraphics, Slot slot, boolean scale) {
        Pair pair;
        int x = slot.x;
        int y = slot.y;
        ItemStack stack = slot.getItem();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        if (stack.isEmpty() && (pair = slot.getNoItemIcon()) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            guiGraphics.blit(this.guiLeft + x, this.guiTop + y, 0, 16, 16, sprite);
        }
        if (!stack.isEmpty()) {
            if (scale) {
                poseStack.scale(1.5f, 1.5f, 1.5f);
                ItemRenderHelper.renderItem(guiGraphics, (int)((double)(this.guiLeft + x) / 1.5) + 6, (int)((double)(this.guiTop + y) / 1.5) + 6, stack);
            } else {
                ItemRenderHelper.renderItem(guiGraphics, this.guiLeft + x + 8, this.guiTop + y + 8, stack);
            }
        }
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Minecraft mc = this.minecraft;
        if (mc != null && button == 0 && mc.player != null) {
            for (int i1 = 0; i1 < mc.player.inventoryMenu.slots.size(); ++i1) {
                ItemStack stack;
                Slot slot = (Slot)mc.player.inventoryMenu.slots.get(i1);
                if (!(mouseX - (double)this.guiLeft >= (double)slot.x) || !(mouseX - (double)this.guiLeft <= (double)(slot.x + 16)) || !(mouseY - (double)this.guiTop >= (double)slot.y) || !(mouseY - (double)this.guiTop <= (double)(slot.y + 16)) || (stack = slot.getItem()).isEmpty()) continue;
                ClickActionScreen.item = stack.copy();
                ScreenStack.pop();
                return true;
            }
        }
        return false;
    }

    public void removed() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

