/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu.button;

import com.girafi.minemenu.helper.ItemRenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ItemButton
extends Button {
    @Nonnull
    public ItemStack icon;

    public ItemButton(int xPos, int yPos, int width, int height, @Nonnull ItemStack icon, Button.OnPress handler) {
        super(xPos, yPos, width, height, (Component)Component.literal((String)""), handler, DEFAULT_NARRATION);
        this.icon = icon;
    }

    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partial);
            boolean bl = this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int k = !this.active ? 0 : (this.isHoveredOrFocused() ? 2 : 1);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            if (this.icon.isEmpty()) {
                this.icon = new ItemStack((ItemLike)Blocks.STONE);
            }
            ItemRenderHelper.renderItem(guiGraphics, this.getX() + this.width / 2, this.getY() + this.height / 2, this.icon);
        }
    }
}

