/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu.list;

import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class GuiControlList
extends ContainerObjectSelectionList<KeyBindsList.Entry> {
    public final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.width + 32, parent.height, 25, parent.height - 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.getInstance().options.keyMappings;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.getCategory();
            if (keybinding.getName().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)category)));
            }
            if ((width = mc.font.width(I18n.get((String)keybinding.getName(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.addEntry((AbstractSelectionList.Entry)new KeyEntry((KeyMapping)keybinding));
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry {
        final Component name;
        private final int width;

        public CategoryEntry(Component name) {
            this.name = name;
            this.width = GuiControlList.this.mc.font.width((FormattedText)this.name);
        }

        public void render(@Nonnull GuiGraphics guiGraphics, int slotIndex, int x, int y, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = GuiControlList.this.mc.font;
            int n = Objects.requireNonNull(GuiControlList.this.mc.screen).width / 2 - this.width / 2;
            Objects.requireNonNull(GuiControlList.this.mc.font);
            guiGraphics.drawString(font, this.name, n, x + rowWidth - 9 - 1, 0xFFFFFF);
        }

        @Nonnull
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Nonnull
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(@Nonnull NarrationElementOutput output) {
                    output.add(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        protected void refreshEntry() {
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry {
        private final KeyMapping key;
        private final Component name;
        private final Button buttonSelect;

        KeyEntry(KeyMapping keyBinding) {
            this.key = keyBinding;
            this.name = Component.translatable((String)keyBinding.getName());
            this.buttonSelect = Button.builder((Component)this.name, screen -> {
                ClickActionScreen.keyBinding = keyBinding;
                ScreenStack.pop();
            }).bounds(0, 0, 95, 18).build();
            this.refreshEntry();
        }

        public void render(@Nonnull GuiGraphics guiGraphics, int slotIndex, int x, int y, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = GuiControlList.this.mc.font;
            int n = y + 90 - GuiControlList.this.maxWidth;
            int n2 = x + rowWidth / 2;
            Objects.requireNonNull(GuiControlList.this.mc.font);
            guiGraphics.drawString(font, this.name, n, n2 - 9 / 2, 0xFFFFFF);
            this.buttonSelect.setX(y + 105);
            this.buttonSelect.setY(x);
            this.buttonSelect.setMessage(this.key.getTranslatedKeyMessage());
            this.buttonSelect.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Nonnull
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean mouseClicked(double x, double y, int button) {
            return this.buttonSelect.mouseClicked(x, y, button);
        }

        public boolean mouseReleased(double x, double y, int button) {
            return this.buttonSelect.mouseReleased(x, y, button);
        }

        protected void refreshEntry() {
            this.buttonSelect.setMessage(this.key.getTranslatedKeyMessage());
            MutableComponent mutablecomponent = Component.empty();
            if (!this.key.isUnbound()) {
                for (KeyMapping keymapping : ((GuiControlList)GuiControlList.this).minecraft.options.keyMappings) {
                    if (keymapping == this.key || !this.key.same(keymapping)) continue;
                    mutablecomponent.append((Component)Component.translatable((String)keymapping.getName()));
                }
            }
        }

        public KeyMapping getKey() {
            return this.key;
        }
    }
}

