/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.gui.controlling;

import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.platform.Services;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.ArrayUtils;

public class ControllingGuiControlList
extends ContainerObjectSelectionList<KeyBindsList.Entry> {
    private final Minecraft mc;
    private int maxListLabelWidth;
    public List<KeyBindsList.Entry> allEntries;

    public ControllingGuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.width + 20, parent.height - 70, 45, 20);
        this.mc = mc;
        this.children().clear();
        this.allEntries = new ArrayList<KeyBindsList.Entry>();
        Object[] bindings = (KeyMapping[])ArrayUtils.clone((Object[])mc.options.keyMappings);
        Arrays.sort(bindings);
        String lastCategory = null;
        for (Object keybinding : bindings) {
            MutableComponent component;
            int width;
            String category = keybinding.getCategory();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!category.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry((Component)Component.translatable((String)category)));
                }
            }
            if ((width = mc.font.width((FormattedText)(component = Component.translatable((String)keybinding.getName())))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (category.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding, (Component)component));
        }
    }

    public List<KeyBindsList.Entry> getAllEntries() {
        return this.allEntries;
    }

    protected int addEntry(@Nonnull KeyBindsList.Entry ent) {
        if (this.allEntries == null) {
            this.allEntries = new ArrayList<KeyBindsList.Entry>();
        }
        this.allEntries.add(ent);
        this.children().add(ent);
        return this.children().size() - 1;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15 + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry
    implements ICategoryEntry {
        private final Component name;
        private final int labelWidth;

        public CategoryEntry(Component name) {
            this.name = name;
            this.labelWidth = ControllingGuiControlList.this.mc.font.width((FormattedText)this.name);
        }

        public void render(GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.drawString(ControllingGuiControlList.this.mc.font, this.name, Objects.requireNonNull(((ControllingGuiControlList)ControllingGuiControlList.this).minecraft.screen).width / 2 - this.labelWidth / 2, y + rowWidth - 9 - 1, 0xFFFFFF);
        }

        @Nonnull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Nonnull
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(@Nonnull NarrationElementOutput neo) {
                    neo.add(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        @Nonnull
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of();
        }

        protected void refreshEntry() {
        }

        public Component name() {
            return this.name;
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry
    implements IKeyEntry {
        private final KeyMapping key;
        private final Component keyDesc;
        private boolean hasCollision;
        private final Component categoryName;
        private final Button buttonSelect;

        private KeyEntry(KeyMapping key, Component keyDesc) {
            this.key = key;
            this.keyDesc = keyDesc;
            this.categoryName = Component.translatable((String)this.key.getCategory());
            this.buttonSelect = Button.builder((Component)keyDesc, screen -> {
                ClickActionScreen.keyBinding = key;
                ScreenStack.pop();
            }).bounds(0, 0, 95, 18).build();
            this.refreshEntry();
        }

        public void render(@Nonnull GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int length = Math.max(0, x + 90 - ControllingGuiControlList.this.maxListLabelWidth);
            guiGraphics.drawString(ControllingGuiControlList.this.mc.font, this.keyDesc, length, y + rowWidth / 2 - 4, 0xFFFFFF);
            this.buttonSelect.setX(x + 105);
            this.buttonSelect.setY(y);
            this.buttonSelect.setMessage(this.key.getTranslatedKeyMessage());
            this.buttonSelect.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.hasCollision) {
                int markerWidth = 3;
                int minX = this.buttonSelect.getX() - 6;
                guiGraphics.fill(minX, y + 2, minX + markerWidth, y + rowWidth + 2, ChatFormatting.RED.getColor() | 0xFF000000);
            }
        }

        @Nonnull
        public List<GuiEventListener> children() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        @Nonnull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.mouseClicked(mouseX, mouseY, buttonId);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int buttonId) {
            return this.buttonSelect.mouseReleased(mouseX, mouseY, buttonId);
        }

        protected void refreshEntry() {
            this.hasCollision = false;
            MutableComponent duplicates = Component.empty();
            if (!this.key.isUnbound()) {
                KeyMapping[] mappings;
                for (KeyMapping mapping : mappings = ((ControllingGuiControlList)ControllingGuiControlList.this).minecraft.options.keyMappings) {
                    if ((mapping == this.key || !this.key.same(mapping)) && !Services.PLATFORM.hasConflictingModifier(this.key, mapping)) continue;
                    if (this.hasCollision) {
                        duplicates.append(", ");
                    }
                    this.hasCollision = true;
                    duplicates.append((Component)Component.translatable((String)mapping.getName()));
                }
            }
            MutableComponent tooltip = Component.translatable((String)this.key.getCategory());
            if (this.hasCollision) {
                tooltip.append(CommonComponents.NEW_LINE);
                tooltip.append((Component)Component.translatable((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicates}));
            }
        }

        public Component categoryName() {
            return this.categoryName;
        }

        public KeyMapping getKey() {
            return this.key;
        }

        public Component getKeyDesc() {
            return this.keyDesc;
        }

        public Button getBtnResetKeyBinding() {
            return null;
        }

        public Button getBtnChangeKeyBinding() {
            return null;
        }
    }
}

