/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.gui.controlling;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.gui.controlling.ControllingGuiControlList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.Component;

public class ControllingPickKeyScreen
extends Screen {
    private ControllingGuiControlList controlList;
    private AutoCompletingEditBox<KeyBindsList.Entry> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private Button buttonNone;
    private Button buttonSort;
    private final Button.OnPress PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.setMessage(this.sortOrder.getDisplay());
        this.filterKeys();
    };

    public ControllingPickKeyScreen() {
        super((Component)Component.translatable((String)"mine_menu.keyScreen.title"));
    }

    protected void init() {
        super.init();
        this.controlList = new ControllingGuiControlList(this, this.minecraft);
        int searchX = this.controlList.getRowWidth();
        int btnWidth = 74;
        int groupPadding = 5;
        int centerX = this.width / 2;
        int leftX = centerX - 150 - groupPadding;
        int rightX = centerX + groupPadding;
        int bottomY = this.height + 1;
        int rowSpacing = 24;
        int topRowY = bottomY - rowSpacing;
        Supplier<List> listSupplier = () -> this.controlList.getAllEntries();
        this.search = (AutoCompletingEditBox)this.addRenderableWidget((GuiEventListener)new AutoCompletingEditBox(this.font, centerX - searchX / 2, 22, searchX, 20, this.search, (Component)Component.translatable((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier));
        this.search.addResponder(this::filterKeys);
        this.addRenderableOnly((Renderable)this.search.autoComplete());
        this.addWidget((GuiEventListener)this.controlList);
        this.buttonSort = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.sortOrder.getDisplay(), (Button.OnPress)this.PRESS_SORT).bounds(leftX + btnWidth + 2, topRowY, btnWidth, 20).build());
        this.buttonNone = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (Button.OnPress)this.PRESS_NONE).bounds(rightX, topRowY, btnWidth, 20).build());
        this.displayMode = DisplayMode.ALL;
        this.setInitialFocus((GuiEventListener)this.search);
        this.search.moveCursor(0, false);
        this.children().sort(Comparator.comparingInt(value -> value.getRectangle().top()).thenComparingInt(listener -> listener.getRectangle().left()));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void filterKeys() {
        this.filterKeys(this.search.getValue());
    }

    public void filterKeys(String lastSearch) {
        this.controlList.children().clear();
        this.controlList.setScrollAmount(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.controlList.children().addAll(this.controlList.getAllEntries());
            return;
        }
        Predicate extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        ControllingGuiControlList list = this.controlList;
        if (list != null) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> this.sortOrder.sort(entries);
        }
        list.children().addAll(ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.children());
    }

    public boolean mouseScrolled(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.search.autoComplete().mouseScrolled(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.mouseScrolled(xpos, ypos, xDelta, yDelta);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (!this.search.isFocused() && ControllingPickKeyScreen.hasControlDown() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)70)) {
            this.search.setFocused(true);
            return true;
        }
        if (key == 256) {
            ScreenStack.pop();
            this.search.setFocused(false);
            return true;
        }
        return super.keyPressed(key, scancode, mods);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.controlList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, "Select a Key:", this.width / 2, 8, 0xFFFFFF);
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderDirtBackground(guiGraphics);
    }
}

