/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.handler;

import com.girafi.minemenu.data.menu.RadialMenu;
import com.girafi.minemenu.gui.RadialMenuScreen;
import com.girafi.minemenu.util.Config;
import com.girafi.minemenu.util.MineMenuKeybinds;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;

public class KeyboardHandlerHelper {
    public static final KeyboardHandlerHelper INSTANCE = new KeyboardHandlerHelper();
    private static boolean lastWheelState = false;
    private static final List<KeyMapping> FIRED_KEYS = new ArrayList<KeyMapping>();
    private static boolean ignoreNextTick = false;

    private KeyboardHandlerHelper() {
    }

    public void fireKey(KeyMapping keyMapping) {
        FIRED_KEYS.add(keyMapping);
        KeyboardHandlerHelper.activateKeybind(keyMapping, true);
        ignoreNextTick = true;
    }

    public void toggleKey(KeyMapping keyMapping) {
        KeyboardHandlerHelper.activateKeybind(keyMapping, true);
        ignoreNextTick = true;
    }

    public static void onClientTick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        long handle = Minecraft.getInstance().getWindow().getWindow();
        int keycode = MineMenuKeybinds.RADIAL_MENU_OPEN.key.getValue();
        if (keycode >= 0) {
            boolean radialMenuKeyDown;
            boolean bl = MineMenuKeybinds.RADIAL_MENU_OPEN.matchesMouse(keycode) ? GLFW.glfwGetMouseButton((long)handle, (int)keycode) == 1 : (radialMenuKeyDown = InputConstants.isKeyDown((long)handle, (int)keycode));
            if (radialMenuKeyDown != lastWheelState) {
                if (((Boolean)Config.GENERAL.toggle.get()).booleanValue()) {
                    if (radialMenuKeyDown) {
                        if (RadialMenuScreen.active) {
                            if (((Boolean)Config.GENERAL.releaseToSelect.get()).booleanValue()) {
                                RadialMenuScreen.INSTANCE.mouseClicked(mc.mouseHandler.xpos(), mc.mouseHandler.ypos(), 0);
                            }
                            RadialMenuScreen.deactivate();
                        } else if (mc.screen == null || mc.screen instanceof RadialMenuScreen) {
                            RadialMenu.resetCategory();
                            RadialMenu.resetTimer();
                            RadialMenuScreen.activate();
                        }
                    }
                } else if (radialMenuKeyDown != RadialMenuScreen.active) {
                    if (radialMenuKeyDown) {
                        if (mc.screen == null || mc.screen instanceof RadialMenuScreen) {
                            RadialMenu.resetCategory();
                            RadialMenu.resetTimer();
                            RadialMenuScreen.activate();
                        }
                    } else {
                        if (((Boolean)Config.GENERAL.releaseToSelect.get()).booleanValue()) {
                            RadialMenuScreen.INSTANCE.mouseClicked(mc.mouseHandler.xpos(), mc.mouseHandler.ypos(), 0);
                        }
                        RadialMenuScreen.deactivate();
                    }
                }
            }
            lastWheelState = radialMenuKeyDown;
            if (ignoreNextTick) {
                ignoreNextTick = false;
                return;
            }
        }
        Iterator<KeyMapping> iterator = FIRED_KEYS.iterator();
        while (iterator.hasNext()) {
            KeyMapping keyBinding = iterator.next();
            KeyboardHandlerHelper.activateKeybind(keyBinding, false);
            iterator.remove();
        }
    }

    public static void activateKeybind(KeyMapping keyMapping, boolean setDown) {
        keyMapping.setDown(setDown);
        keyMapping.clickCount = setDown ? 1 : 0;
    }
}

