/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class GuiRenderHelper {
    public static void renderHeaderAndFooter(GuiGraphics guiGraphics, Screen base, int headerHeight, int footerHeight, int shadowDepth, String headerText) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.BACKGROUND_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        float f = 32.0f;
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex(0.0, (double)headerHeight, 0.0).uv(0.0f, (float)headerHeight / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0 + (double)base.width, (double)headerHeight, 0.0).uv((float)base.width / f, (float)headerHeight / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0 + (double)base.width, 0.0, 0.0).uv((float)base.width / f, 0.0f / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0, 0.0, 0.0).uv(0.0f, 0.0f / f).color(64, 64, 64, 255).endVertex();
        tessellator.end();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex(0.0, (double)base.height, 0.0).uv(0.0f, (float)headerHeight / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0 + (double)base.width, (double)base.height, 0.0).uv((float)base.width / f, (float)headerHeight / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0 + (double)base.width, (double)base.height - (double)footerHeight, 0.0).uv((float)base.width / f, 0.0f / f).color(64, 64, 64, 255).endVertex();
        bufferBuilder.vertex(0.0, (double)base.height - (double)footerHeight, 0.0).uv(0.0f, 0.0f / f).color(64, 64, 64, 255).endVertex();
        tessellator.end();
        poseStack.popPose();
        poseStack.pushPose();
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, headerText, base.width / 2, 8, 0xFFFFFF);
        poseStack.popPose();
    }
}

