/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.data.click.ClickAction;
import com.girafi.minemenu.data.click.ClickActionCategory;
import com.girafi.minemenu.data.click.ClickActionCommand;
import com.girafi.minemenu.data.click.ClickActionKey;
import com.girafi.minemenu.data.click.ClickActionUseItem;
import com.girafi.minemenu.data.session.EditSessionData;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.gui.controlling.ControllingPickKeyScreen;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.menu.PickItemScreen;
import com.girafi.minemenu.menu.PickKeyScreen;
import com.girafi.minemenu.menu.button.ItemButton;
import com.girafi.minemenu.platform.Services;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ClickActionScreen
extends Screen {
    public static final boolean IS_CONTROLLING_LOADED = Services.PLATFORM.isModLoaded("controlling");
    public static ItemStack item;
    public static KeyMapping keyBinding;
    private static boolean toggle;
    private static boolean clipboard;
    private EditBox textCommand;
    private EditBox textCategory;
    private Button modeCommand;
    private Button modeKeybinding;
    private Button modeUseItem;
    private Button modeCategory;
    private Button commandClipboardButton;
    private Button keybindButton;
    private Button keybindToggleButton;
    private Button selectItemButton;
    private Button buttonCancel;
    private Button buttonConfirm;
    private int mode = 0;

    public ClickActionScreen() {
        super((Component)Component.translatable((String)"mine_menu.actionScreen.title"));
        keyBinding = null;
        item = ItemStack.EMPTY;
    }

    @Nullable
    public GuiEventListener getFocused() {
        if (this.mode == 0) {
            return this.textCommand;
        }
        if (this.mode == 3) {
            return this.textCategory;
        }
        return super.getFocused();
    }

    public void init() {
        MutableComponent keyToggleString;
        this.mode = keyBinding != null ? ClickAction.KEYBIND.ordinal() : (!item.isEmpty() ? ClickAction.ITEM_USE.ordinal() : (EditSessionData.clickAction != null ? EditSessionData.clickAction.getClickAction().ordinal() : 0));
        this.buttonConfirm = Button.builder((Component)Component.translatable((String)"gui.done"), screen -> {
            if (this.mode == 0) {
                EditSessionData.clickAction = !this.textCommand.getValue().trim().isEmpty() ? new ClickActionCommand(this.textCommand.getValue().trim(), clipboard) : null;
            } else if (this.mode == 1 && keyBinding != null) {
                EditSessionData.clickAction = new ClickActionKey(keyBinding.getName(), toggle);
            } else if (this.mode == 2 && !item.isEmpty()) {
                EditSessionData.clickAction = new ClickActionUseItem(item);
            } else if (this.mode == 3) {
                EditSessionData.clickAction = !this.textCategory.getValue().trim().isEmpty() ? new ClickActionCategory(this.textCategory.getValue().trim()) : null;
            }
            ScreenStack.pop();
        }).bounds(this.width / 2 - 4 - 150, this.height - 60, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonConfirm);
        this.buttonCancel = Button.builder((Component)Component.translatable((String)"gui.cancel"), screen -> ScreenStack.pop()).bounds(this.width / 2 + 4, this.height - 60, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonCancel);
        MutableComponent commandString = EditSessionData.clickAction instanceof ClickActionCommand ? Component.translatable((String)(((ClickActionCommand)EditSessionData.clickAction).clipboard ? "mine_menu.clipboard" : "mine_menu.send")) : Component.translatable((String)(clipboard ? "mine_menu.clipboard" : "mine_menu.send"));
        this.commandClipboardButton = Button.builder((Component)commandString, screen -> {
            clipboard = !clipboard;
            this.commandClipboardButton.setMessage((Component)Component.translatable((String)(clipboard ? "mine_menu.clipboard" : "mine_menu.send")));
        }).bounds(this.width / 2 - 75, 80, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.commandClipboardButton);
        MutableComponent keyString = keyBinding != null ? Component.translatable((String)keyBinding.getName()) : (EditSessionData.clickAction instanceof ClickActionKey ? Component.translatable((String)((ClickActionKey)EditSessionData.clickAction).key) : Component.translatable((String)"mine_menu.selectKey"));
        if (IS_CONTROLLING_LOADED) {
            this.keybindButton = Button.builder((Component)keyString, screen -> ScreenStack.push(new ControllingPickKeyScreen())).bounds(this.width / 2 - 75, 50, 150, 20).build();
            this.addRenderableWidget((GuiEventListener)this.keybindButton);
        } else {
            this.keybindButton = Button.builder((Component)keyString, screen -> ScreenStack.push(new PickKeyScreen())).bounds(this.width / 2 - 75, 50, 150, 20).build();
            this.addRenderableWidget((GuiEventListener)this.keybindButton);
        }
        if (EditSessionData.clickAction instanceof ClickActionKey) {
            ClickActionKey cfr_ignored_0 = (ClickActionKey)EditSessionData.clickAction;
            keyToggleString = Component.translatable((String)(ClickActionKey.toggle ? "mine_menu.toggle" : "mine_menu.press"));
        } else {
            keyToggleString = Component.translatable((String)(toggle ? "mine_menu.toggle" : "mine_menu.press"));
        }
        this.keybindToggleButton = Button.builder((Component)keyToggleString, screen -> {
            ClickActionKey.toggle = toggle = !toggle;
            this.keybindToggleButton.setMessage((Component)Component.translatable((String)(toggle ? "mine_menu.toggle" : "mine_menu.press")));
        }).bounds(this.width / 2 - 75, 80, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.keybindToggleButton);
        MutableComponent itemString = !item.isEmpty() ? Component.literal((String)("Item: " + item.getHoverName().getString())) : (EditSessionData.clickAction != null && EditSessionData.clickAction.getClickAction() == ClickAction.ITEM_USE ? Component.literal((String)("Item: " + ((ClickActionUseItem)EditSessionData.clickAction).stack.getItem().getDescription().getString())) : Component.translatable((String)"mine_menu.selectSlot"));
        this.selectItemButton = Button.builder((Component)itemString, screen -> ScreenStack.push(new PickItemScreen())).bounds(this.width / 2 - 75, 50, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.selectItemButton);
        this.modeCommand = new ItemButton(this.width / 2 - 55, this.height - 90, 20, 20, new ItemStack((ItemLike)Items.PAPER), screen -> {
            this.mode = 0;
            this.modeCategory.active = true;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = true;
            this.modeCommand.active = false;
            this.textCategory.setVisible(false);
            this.selectItemButton.visible = false;
            this.textCommand.setVisible(true);
            this.commandClipboardButton.visible = true;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addRenderableWidget((GuiEventListener)this.modeCommand);
        this.modeKeybinding = new ItemButton(this.width / 2 - 25, this.height - 90, 20, 20, new ItemStack((ItemLike)Blocks.OAK_BUTTON), screen -> {
            this.mode = 1;
            this.modeCategory.active = true;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = false;
            this.modeCommand.active = true;
            this.textCategory.setVisible(false);
            this.selectItemButton.visible = false;
            this.textCommand.setVisible(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = true;
            this.keybindToggleButton.visible = true;
        });
        this.addRenderableWidget((GuiEventListener)this.modeKeybinding);
        this.modeUseItem = new ItemButton(this.width / 2 + 5, this.height - 90, 20, 20, new ItemStack((ItemLike)Items.DIAMOND_SWORD), screen -> {
            this.mode = 2;
            this.modeCategory.active = true;
            this.modeUseItem.active = false;
            this.modeKeybinding.active = true;
            this.modeCommand.active = true;
            this.textCategory.setVisible(false);
            this.selectItemButton.visible = true;
            this.textCommand.setVisible(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addRenderableWidget((GuiEventListener)this.modeUseItem);
        this.modeCategory = new ItemButton(this.width / 2 + 35, this.height - 90, 20, 20, new ItemStack((ItemLike)Blocks.CHEST), screen -> {
            this.mode = 3;
            this.modeCategory.active = false;
            this.modeUseItem.active = true;
            this.modeKeybinding.active = true;
            this.modeCommand.active = true;
            this.textCategory.setVisible(true);
            this.selectItemButton.visible = false;
            this.textCommand.setVisible(false);
            this.commandClipboardButton.visible = false;
            this.keybindButton.visible = false;
            this.keybindToggleButton.visible = false;
        });
        this.addRenderableWidget((GuiEventListener)this.modeCategory);
        this.textCommand = new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)Component.translatable((String)"mine_menu.clickAction_command"));
        this.textCommand.setMaxLength(Short.MAX_VALUE);
        this.textCommand.setFocused(true);
        this.textCommand.setValue(EditSessionData.clickAction instanceof ClickActionCommand ? ((ClickActionCommand)EditSessionData.clickAction).command : "");
        this.textCategory = new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)Component.translatable((String)"mine_menu.clickAction.category"));
        this.textCategory.setMaxLength(Short.MAX_VALUE);
        this.textCategory.setFocused(true);
        this.textCategory.setValue(EditSessionData.clickAction instanceof ClickActionCategory ? ((ClickActionCategory)EditSessionData.clickAction).category : "");
        this.modeCommand.active = this.mode != 0;
        this.modeKeybinding.active = this.mode != 1;
        this.modeUseItem.active = this.mode != 2;
        this.modeCategory.active = this.mode != 3;
        this.textCommand.setVisible(this.mode == 0);
        this.commandClipboardButton.visible = this.mode == 0;
        this.keybindButton.visible = this.mode == 1;
        this.keybindToggleButton.visible = this.mode == 1;
        this.selectItemButton.visible = this.mode == 2;
        this.textCategory.setVisible(this.mode == 3);
    }

    public void removed() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keycode) {
        this.textCommand.charTyped(key, keycode);
        this.textCategory.charTyped(key, keycode);
        return true;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        super.mouseClicked(mx, my, button);
        this.textCommand.mouseClicked(mx, my, button);
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.textCommand.render(guiGraphics, mouseX, mouseY, partial);
        this.textCategory.render(guiGraphics, mouseX, mouseY, partial);
        String header = switch (this.mode) {
            case 0 -> "Enter a command";
            case 1 -> "Select a key";
            case 2 -> "Pick an item";
            case 3 -> "Enter a category";
            default -> "";
        };
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, header);
        if (mouseX > this.modeCommand.getX() && mouseX < this.modeCommand.getX() + this.modeCommand.getWidth() && mouseY > this.modeCommand.getY() && mouseY < this.modeCommand.getY() + this.modeCommand.getWidth()) {
            guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"mine_menu.clickAction_command").getVisualOrderText()), mouseX, mouseY);
        } else if (mouseX > this.modeKeybinding.getX() && mouseX < this.modeKeybinding.getX() + this.modeKeybinding.getWidth() && mouseY > this.modeKeybinding.getY() && mouseY < this.modeKeybinding.getY() + this.modeKeybinding.getWidth()) {
            guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"mine_menu.clickAction_keybinding").getVisualOrderText()), mouseX, mouseY);
        } else if (mouseX > this.modeUseItem.getX() && mouseX < this.modeUseItem.getX() + this.modeUseItem.getWidth() && mouseY > this.modeUseItem.getY() && mouseY < this.modeUseItem.getY() + this.modeUseItem.getWidth()) {
            guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"mine_menu.clickAction_useItem").getVisualOrderText()), mouseX, mouseY);
        } else if (mouseX > this.modeCategory.getX() && mouseX < this.modeCategory.getX() + this.modeCategory.getWidth() && mouseY > this.modeCategory.getY() && mouseY < this.modeCategory.getY() + this.modeCategory.getWidth()) {
            guiGraphics.renderTooltip(this.font, Collections.singletonList(Component.translatable((String)"mine_menu.clickAction_category").getVisualOrderText()), mouseX, mouseY);
        }
    }

    static {
        toggle = false;
        clipboard = false;
    }
}

