/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.MineMenuCommon;
import com.girafi.minemenu.data.click.ClickActionCategory;
import com.girafi.minemenu.data.click.ClickActionCommand;
import com.girafi.minemenu.data.click.ClickActionKey;
import com.girafi.minemenu.data.click.ClickActionUseItem;
import com.girafi.minemenu.data.json.MenuLoader;
import com.girafi.minemenu.data.menu.MenuItem;
import com.girafi.minemenu.data.menu.RadialMenu;
import com.girafi.minemenu.data.session.EditSessionData;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.menu.ClickActionScreen;
import com.girafi.minemenu.menu.PickIconScreen;
import com.girafi.minemenu.menu.button.ItemButton;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class MenuItemScreen
extends Screen {
    private final int slot;
    private EditBox textTitle;
    private Button buttonCancel;
    private Button buttonConfirm;
    private Button buttonDelete;
    private ItemButton buttonPickIcon;
    private Button buttonClickAction;

    public MenuItemScreen(int slot, MenuItem menuItem) {
        super((Component)Component.translatable((String)"mine_menu.itemScreen.title"));
        this.slot = slot;
        EditSessionData.fromMenuItem(menuItem);
    }

    public void tick() {
        this.buttonConfirm.visible = EditSessionData.clickAction != null;
        this.buttonDelete.visible = RadialMenu.getActiveArray()[this.slot] != null;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.textTitle;
    }

    public void init() {
        this.buttonConfirm = Button.builder((Component)Component.translatable((String)"gui.done"), screen -> {
            EditSessionData.title = EditSessionData.title.isEmpty() ? "Menu Item #" + this.slot : this.textTitle.getValue();
            if (EditSessionData.clickAction != null) {
                if (RadialMenu.getActiveArray()[this.slot] != null) {
                    RadialMenu.getActiveArray()[this.slot].onRemoved();
                }
                RadialMenu.getActiveArray()[this.slot] = EditSessionData.toMenuItem();
            }
            MenuLoader.save(MineMenuCommon.menuFile);
            Minecraft.getInstance().setScreen(null);
        }).bounds(this.width / 2 - 4 - 150, this.height - 60, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonConfirm);
        this.buttonCancel = Button.builder((Component)Component.translatable((String)"gui.cancel"), screen -> Minecraft.getInstance().setScreen(null)).bounds(this.width / 2 + 4 + 50, this.height - 60, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonCancel);
        this.buttonDelete = Button.builder((Component)Component.translatable((String)"gui.delete"), screen -> {
            if (RadialMenu.getActiveArray()[this.slot] != null) {
                RadialMenu.getActiveArray()[this.slot].onRemoved();
                RadialMenu.getActiveArray()[this.slot] = null;
                MenuLoader.save(MineMenuCommon.menuFile);
                Minecraft.getInstance().setScreen(null);
            }
        }).bounds(this.width / 2 - 50, this.height - 60, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonDelete);
        this.buttonPickIcon = new ItemButton(this.width / 2 - 4 - 40, this.height / 2, 20, 20, new ItemStack((ItemLike)Blocks.STONE), screen -> ScreenStack.push(new PickIconScreen()));
        this.addRenderableWidget((GuiEventListener)this.buttonPickIcon);
        MutableComponent string = Component.translatable((String)"mine_menu.action");
        if (EditSessionData.clickAction != null) {
            if (EditSessionData.clickAction instanceof ClickActionCommand) {
                string = Component.translatable((String)"mine_menu.command");
            } else if (EditSessionData.clickAction instanceof ClickActionKey) {
                string = Component.translatable((String)"mine_menu.keybind");
            } else if (EditSessionData.clickAction instanceof ClickActionUseItem) {
                string = Component.translatable((String)"mine_menu.useItem");
            } else if (EditSessionData.clickAction instanceof ClickActionCategory) {
                string = Component.translatable((String)"mine_menu.category");
            }
        }
        this.buttonClickAction = Button.builder((Component)string, screen -> ScreenStack.push(new ClickActionScreen())).bounds(this.width / 2 - 20, this.height / 2, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonClickAction);
        this.textTitle = new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)Component.translatable((String)"mine_menu.menuItem.title"));
        this.textTitle.setMaxLength(Short.MAX_VALUE);
        this.textTitle.setFocused(true);
        this.textTitle.setValue(EditSessionData.title != null && !EditSessionData.title.isEmpty() ? EditSessionData.title : "");
        this.buttonPickIcon.icon = EditSessionData.icon;
    }

    public void removed() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keycode) {
        this.textTitle.charTyped(key, keycode);
        return true;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        super.mouseClicked(mx, my, button);
        this.textTitle.mouseClicked(mx, my, button);
        return true;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            ScreenStack.pop();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.textTitle.render(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.drawCenteredString(this.font, "Enter a title, then configure using the options below", this.width / 2, 80, 0xFFFFFF);
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, "Modifying Menu Item #" + this.slot);
    }
}

