/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.minemenu.menu;

import com.girafi.minemenu.MineMenuCommon;
import com.girafi.minemenu.data.session.EditSessionData;
import com.girafi.minemenu.gui.ScreenStack;
import com.girafi.minemenu.helper.GuiRenderHelper;
import com.girafi.minemenu.helper.ItemRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PickIconScreen
extends Screen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private EditBox textSearch;
    private Button buttonDone;
    private Button buttonCancel;
    private NonNullList<ItemStack> stacks;
    private int listScrollIndex = 0;
    private ItemStack iconStack = ItemStack.EMPTY;

    public PickIconScreen() {
        super((Component)Component.translatable((String)"mine_menu.iconScreen.title"));
    }

    public void tick() {
        if (this.textSearch.getValue().trim().isEmpty()) {
            this.reconstructList(this.stacks);
        }
    }

    private void reconstructList(NonNullList<ItemStack> list) {
        list.clear();
        for (Item registryItem : BuiltInRegistries.ITEM) {
            ItemStack stack = new ItemStack((ItemLike)registryItem);
            if (stack.isEmpty() || stack == null) continue;
            list.add((Object)stack);
        }
    }

    public void init() {
        this.stacks = NonNullList.create();
        this.reconstructList(this.stacks);
        this.buttonDone = Button.builder((Component)Component.translatable((String)"gui.done"), screen -> {
            String inputText = this.textSearch.getValue();
            if (inputText.contains("{")) {
                CompoundTag tag = new CompoundTag();
                try {
                    tag = TagParser.parseTag((String)inputText);
                }
                catch (CommandSyntaxException e) {
                    MineMenuCommon.LOGGER.info("Invalid item NBT");
                    e.printStackTrace();
                }
                ItemStack tagStack = ItemStack.of((CompoundTag)tag);
                EditSessionData.icon = ItemStack.of((CompoundTag)tag);
                if (!tagStack.isEmpty() && tagStack != null) {
                    EditSessionData.icon = tagStack;
                    ScreenStack.pop();
                }
            } else {
                Item textItem = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(inputText));
                if (textItem == Items.AIR && textItem != null) {
                    MineMenuCommon.LOGGER.warn("Invalid item");
                } else {
                    EditSessionData.icon = new ItemStack((ItemLike)textItem);
                    ScreenStack.pop();
                }
            }
        }).bounds(this.width / 2 - 150, this.height - 60 + 12, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonDone);
        this.buttonCancel = Button.builder((Component)Component.translatable((String)"gui.cancel"), screen -> ScreenStack.pop()).bounds(this.width / 2, this.height - 60 + 12, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonCancel);
        this.textSearch = new EditBox(this.font, this.width / 2 - 150, 40, 300, 20, (Component)Component.translatable((String)"mine_menu.pickIcon.search"));
        this.textSearch.setMaxLength(Short.MAX_VALUE);
        this.textSearch.setFocused(true);
        if (!EditSessionData.icon.isEmpty()) {
            if (EditSessionData.icon.hasTag()) {
                this.textSearch.setValue(EditSessionData.icon.save(EditSessionData.icon.getTag()).toString());
            } else {
                this.textSearch.setValue(BuiltInRegistries.ITEM.getKey((Object)EditSessionData.icon.getItem()).toString());
            }
        }
    }

    public void removed() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char key, int keyCode) {
        if (this.textSearch.charTyped(key, (int)key)) {
            this.listScrollIndex = 0;
            if (!this.textSearch.getValue().trim().isEmpty()) {
                this.stacks.clear();
                NonNullList temp = NonNullList.create();
                if (this.textSearch.getValue().equalsIgnoreCase(".inv")) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player != null) {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack stack = player.getInventory().getItem(i);
                            this.stacks.add((Object)stack.copy());
                        }
                    }
                } else {
                    this.reconstructList((NonNullList<ItemStack>)temp);
                    for (ItemStack stack : temp) {
                        if (!stack.getHoverName().getString().toLowerCase().contains(this.textSearch.getValue().toLowerCase())) continue;
                        this.stacks.add((Object)stack);
                    }
                }
                return true;
            }
            return super.charTyped(key, keyCode);
        }
        return false;
    }

    public boolean keyPressed(int keycode, int i2, int i3) {
        if (keycode == 256) {
            ScreenStack.pop();
            return true;
        }
        if (this.textSearch.keyPressed(keycode, i2, i3)) {
            return true;
        }
        return super.keyPressed(keycode, i2, i3);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.width / 2, this.height - (Minecraft.getInstance().getWindow().getGuiScaledHeight() - 80), mouseX, mouseY);
        if (!clicked.isEmpty()) {
            this.textSearch.setValue(BuiltInRegistries.ITEM.getKey((Object)clicked.getItem()).toString());
            this.iconStack = clicked;
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double d, double wheel) {
        if ((wheel = -wheel) < 0.0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
            return true;
        }
        if (wheel > 0.0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
            return true;
        }
        return false;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.textSearch.render(guiGraphics, mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(guiGraphics, this, 25, 20, 5, "Select an Icon:");
        this.drawList(guiGraphics, this.width / 2, this.height - (Minecraft.getInstance().getWindow().getGuiScaledHeight() - 80), mouseX, mouseY);
    }

    private void drawList(GuiGraphics guiGraphics, int x, int y, int mx, int my) {
        ItemStack highlighted = ItemStack.EMPTY;
        int highlightedX = 0;
        int highlightedY = 0;
        int amountOfRowsThatFits = (this.minecraft.getWindow().getGuiScaledHeight() - 150) / 16;
        amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) break;
            boolean scaled = false;
            int actualDrawX = x + drawX * 20 - 140 + 10;
            int actualDrawY = y + drawY * 20;
            if (mx > actualDrawX - 8 && mx < actualDrawX + 20 - 8 && my > (actualDrawY -= 20 * this.listScrollIndex) - 8 && my < actualDrawY + 20 - 8) {
                scaled = true;
                highlighted = (ItemStack)this.stacks.get(i);
                highlightedX = actualDrawX / 2;
                highlightedY = actualDrawY / 2;
            }
            if (scaled) continue;
            ItemRenderHelper.renderItem(guiGraphics, actualDrawX, actualDrawY, (ItemStack)this.stacks.get(i));
        }
        if (!highlighted.isEmpty()) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.scale(2.0f, 2.0f, 2.0f);
            ItemRenderHelper.renderItem(guiGraphics, highlightedX, highlightedY, highlighted);
            poseStack.popPose();
        }
    }

    @Nonnull
    private ItemStack getClickedStack(int x, int y, double mx, double my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            int amountOfRowsThatFits = (this.minecraft.getWindow().getGuiScaledHeight() - 150) / 16;
            int n = amountOfRowsThatFits = amountOfRowsThatFits > 7 ? amountOfRowsThatFits - 6 : amountOfRowsThatFits;
            if ((i - 14 * this.listScrollIndex) / 14 > amountOfRowsThatFits) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!(mx > (double)(actualDrawX - 8.0f)) || !(mx < (double)(actualDrawX + 20.0f - 8.0f)) || !(my > (double)(actualDrawY - 8.0f)) || !(my < (double)(actualDrawY + 20.0f - 8.0f))) continue;
            return (ItemStack)this.stacks.get(i);
        }
        return ItemStack.EMPTY;
    }
}

