/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu.list;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import dmillerw.menu.gui.ScreenStack;
import dmillerw.menu.gui.menu.ClickActionScreen;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiControlList
extends AbstractOptionList<KeyBindingList.Entry> {
    public final Minecraft mc;
    private int maxWidth = 0;

    public GuiControlList(Screen parent, Minecraft mc) {
        super(mc, parent.field_230708_k_, parent.field_230709_l_, 25, parent.field_230709_l_ - 20, 20);
        this.mc = mc;
        Object[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        Arrays.sort(keyBindings);
        String lastCategory = "";
        for (Object keybinding : keyBindings) {
            int width;
            String category = keybinding.func_151466_e();
            if (keybinding.func_151464_g().equalsIgnoreCase("key.open_menu")) continue;
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                this.func_230513_b_((AbstractList.AbstractListEntry)new CategoryEntry(category));
            }
            if ((width = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxWidth) {
                this.maxWidth = width;
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new KeyEntry((KeyBinding)keybinding));
        }
    }

    public int getWidth() {
        return super.getWidth() + 32;
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends KeyBindingList.Entry {
        private final KeyBinding keyBinding;
        private final TranslationTextComponent description;
        private final Button buttonSelect;

        KeyEntry(KeyBinding keyBinding) {
            this.keyBinding = keyBinding;
            this.description = new TranslationTextComponent(keyBinding.func_151464_g());
            this.buttonSelect = new Button(0, 0, 95, 18, (ITextComponent)this.description, screen -> {
                ClickActionScreen.keyBinding = keyBinding;
                ScreenStack.pop();
            });
        }

        public void func_230432_a_(@Nonnull MatrixStack matrixStack, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            FontRenderer fontRenderer = GuiControlList.this.mc.field_71466_p;
            float f = p_230432_4_ + 90 - GuiControlList.this.maxWidth;
            int n = p_230432_3_ + p_230432_6_ / 2;
            GuiControlList.this.mc.field_71466_p.getClass();
            fontRenderer.func_243246_a(matrixStack, (ITextComponent)this.description, f, (float)(n - 9 / 2), 0xFFFFFF);
            this.buttonSelect.field_230690_l_ = p_230432_4_ + 105;
            this.buttonSelect.field_230691_m_ = p_230432_3_;
            this.buttonSelect.func_238482_a_(this.keyBinding.func_238171_j_());
            this.buttonSelect.func_230431_b_(matrixStack, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        @Nonnull
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.buttonSelect);
        }

        public boolean func_231044_a_(double x, double y, int button) {
            return this.buttonSelect.func_231044_a_(x, y, button);
        }

        public boolean func_231048_c_(double x, double y, int button) {
            return this.buttonSelect.func_231048_c_(x, y, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends KeyBindingList.Entry {
        private final String category;
        private final int width;

        CategoryEntry(String category) {
            this.category = I18n.func_135052_a((String)category, (Object[])new Object[0]);
            this.width = GuiControlList.this.mc.field_71466_p.func_78256_a(this.category);
        }

        public void func_230432_a_(@Nonnull MatrixStack matrixStack, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            FontRenderer fontRenderer = GuiControlList.this.mc.field_71466_p;
            float f = Objects.requireNonNull(GuiControlList.this.mc.field_71462_r).field_230708_k_ / 2 - this.width / 2;
            GuiControlList.this.mc.field_71466_p.getClass();
            fontRenderer.func_238421_b_(matrixStack, this.category, f, (float)(p_230432_3_ + p_230432_6_ - 9 - 1), 0xFFFFFF);
        }

        @Nonnull
        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public boolean func_231049_c__(boolean changeFocus) {
            return false;
        }
    }
}

