/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.FilterGuiFactory;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.RadioButton;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.ModuleSettingsMessage;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.Range;

public class GuiModule
extends GuiContainerBase<ContainerModule>
implements IContainerListener,
IMouseOverHelpProvider,
ISendToServer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("modularrouters", "textures/gui/module.png");
    static final XYPoint SMALL_TEXTFIELD_XY = new XYPoint(0, 198);
    static final XYPoint LARGE_TEXTFIELD_XY = new XYPoint(0, 212);
    static final XYPoint BUTTON_XY = new XYPoint(0, 226);
    private static final int GUI_HEIGHT = 198;
    private static final int GUI_WIDTH = 192;
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    final ItemStack moduleItemStack;
    private final ItemModule module;
    private final BlockPos routerPos;
    private final int moduleSlotIndex;
    private final Hand hand;
    private ItemModule.RelativeDirection facing;
    private int sendDelay;
    private int regulatorAmount;
    private final MouseOverHelp mouseOverHelp;
    final ItemAugment.AugmentCounter augmentCounter;
    private final boolean matchAll;
    private RedstoneBehaviourButton redstoneButton;
    private RegulatorTooltipButton regulatorTooltipButton;
    private final DirectionButton[] directionButtons = new DirectionButton[ItemModule.RelativeDirection.values().length];
    private final ModuleToggleButton[] toggleButtons = new ModuleToggleButton[ItemModule.ModuleFlags.values().length];
    private MouseOverHelp.Button mouseOverHelpButton;
    private TexturedToggleButton matchAllButton;
    IntegerTextField regulatorTextField;
    private TerminationButton terminationButton;
    private static final int THRESHOLD = 129;

    public GuiModule(ContainerModule container, PlayerInventory inventory, ITextComponent displayName) {
        super(container, inventory, displayName);
        MFLocator locator = container.getLocator();
        this.moduleSlotIndex = locator.routerSlot;
        this.hand = locator.hand;
        this.routerPos = locator.routerPos;
        this.moduleItemStack = locator.getModuleStack(inventory.field_70458_d);
        this.module = (ItemModule)this.moduleItemStack.func_77973_b();
        this.facing = ModuleHelper.getRelativeDirection(this.moduleItemStack);
        this.regulatorAmount = ModuleHelper.getRegulatorAmount(this.moduleItemStack);
        this.augmentCounter = new ItemAugment.AugmentCounter(this.moduleItemStack);
        this.matchAll = ModuleHelper.isMatchAll(this.moduleItemStack);
        this.field_146999_f = 192;
        this.field_147000_g = 198;
        this.mouseOverHelp = new MouseOverHelp(this);
        this.field_230711_n_ = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.addToggleButton(ItemModule.ModuleFlags.BLACKLIST, 7, 75);
        this.addToggleButton(ItemModule.ModuleFlags.IGNORE_DAMAGE, 7, 93);
        this.addToggleButton(ItemModule.ModuleFlags.IGNORE_NBT, 25, 75);
        this.addToggleButton(ItemModule.ModuleFlags.IGNORE_TAGS, 25, 93);
        this.terminationButton = (TerminationButton)this.func_230480_a_((Widget)new TerminationButton(this.field_147003_i + 45, this.field_147009_r + 93, ModuleHelper.getTermination(this.moduleItemStack)));
        this.matchAllButton = new MatchAllButton(this.field_147003_i + 45, this.field_147009_r + 75, this.matchAll);
        this.func_230480_a_((Widget)this.matchAllButton);
        if (this.module.isDirectional()) {
            this.addDirectionButton(ItemModule.RelativeDirection.NONE, 70, 18);
            this.addDirectionButton(ItemModule.RelativeDirection.UP, 87, 18);
            this.addDirectionButton(ItemModule.RelativeDirection.LEFT, 70, 35);
            this.addDirectionButton(ItemModule.RelativeDirection.FRONT, 87, 35);
            this.addDirectionButton(ItemModule.RelativeDirection.RIGHT, 104, 35);
            this.addDirectionButton(ItemModule.RelativeDirection.DOWN, 87, 52);
            this.addDirectionButton(ItemModule.RelativeDirection.BACK, 104, 52);
        }
        this.mouseOverHelpButton = new MouseOverHelp.Button(this.field_147003_i + 175, this.field_147009_r + 1);
        this.func_230480_a_((Widget)this.mouseOverHelpButton);
        this.redstoneButton = new RedstoneBehaviourButton(this.field_147003_i + 170, this.field_147009_r + 93, 16, 16, ModuleHelper.getRedstoneBehaviour(this.moduleItemStack), (ISendToServer)this);
        this.func_230480_a_((Widget)this.redstoneButton);
        this.regulatorTextField = this.buildRegulationTextField(this.getOrCreateTextFieldManager());
        this.func_230480_a_((Widget)this.regulatorTextField);
        this.regulatorTooltipButton = new RegulatorTooltipButton(this.regulatorTextField.field_230690_l_ - 16, this.regulatorTextField.field_230691_m_ - 2, this.module.isFluidModule());
        this.func_230480_a_((Widget)this.regulatorTooltipButton);
        if (this.routerPos != null) {
            this.func_230480_a_((Widget)new BackButton(this.field_147003_i + 2, this.field_147009_r + 1, p -> PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openRouter(((ContainerModule)this.field_147002_h).getLocator()))));
        }
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 7, this.field_147009_r + 16, this.field_147003_i + 60, this.field_147009_r + 69, "modularrouters.guiText.popup.filter");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 5, this.field_147009_r + 73, this.field_147003_i + 62, this.field_147009_r + 110, "modularrouters.guiText.popup.filterControl");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 68, this.field_147009_r + 16, this.field_147003_i + 121, this.field_147009_r + 69, this.module.isDirectional() ? "modularrouters.guiText.popup.direction" : "modularrouters.guiText.popup.noDirection");
        this.mouseOverHelp.addHelpRegion(this.field_147003_i + 77, this.field_147009_r + 74, this.field_147003_i + 112, this.field_147009_r + 109, "modularrouters.guiText.popup.augments");
    }

    protected IntegerTextField buildRegulationTextField(TextFieldManager manager) {
        IntegerTextField tf = new IntegerTextField(manager, this.field_230712_o_, this.field_147003_i + 166, this.field_147009_r + 75, 20, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(64)));
        tf.setValue(this.regulatorAmount);
        tf.func_212954_a(str -> {
            this.regulatorAmount = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        ((ContainerModule)this.func_212873_a_()).func_82847_b(this);
        ((ContainerModule)this.func_212873_a_()).func_75132_a(this);
        this.setupButtonVisibility();
    }

    public int getRegulatorAmount() {
        return this.regulatorAmount;
    }

    public void setRegulatorAmount(int regulatorAmount) {
        this.regulatorAmount = regulatorAmount;
    }

    protected void setupButtonVisibility() {
        this.redstoneButton.field_230694_p_ = this.augmentCounter.getAugmentCount((Item)ModItems.REDSTONE_AUGMENT.get()) > 0;
        this.regulatorTooltipButton.field_230694_p_ = this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0;
        this.regulatorTextField.func_146189_e(this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0);
    }

    private void addToggleButton(ItemModule.ModuleFlags flag, int x, int y) {
        this.toggleButtons[flag.ordinal()] = new ModuleToggleButton(flag, this.field_147003_i + x, this.field_147009_r + y, ModuleHelper.checkFlag(this.moduleItemStack, flag));
        this.func_230480_a_((Widget)this.toggleButtons[flag.ordinal()]);
    }

    private void addDirectionButton(ItemModule.RelativeDirection dir, int x, int y) {
        this.directionButtons[dir.ordinal()] = new DirectionButton(dir, this.module, this.field_147003_i + x, this.field_147009_r + y, dir == this.facing);
        this.func_230480_a_((Widget)this.directionButtons[dir.ordinal()]);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.mouseOverHelp.setActive(this.mouseOverHelpButton.isToggled());
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.sendToServer();
        }
    }

    void sendModuleSettingsDelayed(int delay) {
        this.sendDelay = delay;
    }

    @Override
    public void sendToServer() {
        PacketHandler.NETWORK.sendToServer((Object)new ModuleSettingsMessage(((ContainerModule)this.field_147002_h).getLocator(), this.buildMessageData()));
    }

    protected CompoundNBT buildMessageData() {
        RouterRedstoneBehaviour behaviour = this.redstoneButton == null ? RouterRedstoneBehaviour.ALWAYS : (RouterRedstoneBehaviour)((Object)this.redstoneButton.getState());
        CompoundNBT compound = new CompoundNBT();
        for (ItemModule.ModuleFlags flag : ItemModule.ModuleFlags.values()) {
            compound.func_74757_a(flag.getName(), this.getToggleButton(flag).isToggled());
        }
        compound.func_74778_a("Termination", ((ItemModule.Termination)((Object)this.terminationButton.getState())).toString());
        compound.func_74778_a("Direction", this.facing.toString());
        compound.func_74774_a("RedstoneMode", (byte)behaviour.ordinal());
        compound.func_74768_a("RegulatorAmount", this.regulatorAmount);
        compound.func_74757_a("MatchAll", this.matchAllButton.isToggled());
        return compound;
    }

    private ModuleToggleButton getToggleButton(ItemModule.ModuleFlags flags) {
        return this.toggleButtons[flags.ordinal()];
    }

    private DirectionButton getDirectionButton(ItemModule.RelativeDirection direction) {
        return this.directionButtons[direction.ordinal()];
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        IFormattableTextComponent title = this.moduleItemStack.func_200301_q().func_230532_e_().func_240702_b_(this.routerPos != null ? " " + I18n.func_135052_a((String)"modularrouters.guiText.label.installed", (Object[])new Object[0]) : "");
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)title, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2.0f, 5.0f, this.getFgColor(this.module.getItemTint()));
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        TintColor c = this.getGuiBackgroundTint();
        RenderSystem.color4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!this.module.isDirectional()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 69, this.field_147009_r + 17, 204, 0, 52, 52);
        }
    }

    private TintColor getGuiBackgroundTint() {
        if (MRConfig.Client.Misc.moduleGuiBackgroundTint) {
            TintColor c = this.module.getItemTint();
            float[] hsb = TintColor.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            return TintColor.getHSBColor(hsb[0], hsb[1] * 0.7f, hsb[2]);
        }
        return TintColor.WHITE;
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode) && !this.isFocused()) && this.routerPos != null) {
            PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openRouter(((ContainerModule)this.field_147002_h).getLocator()));
            return true;
        }
        if (ClientSetup.keybindConfigure.getKey().func_197937_c() == keyCode) {
            return this.handleFilterConfig();
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        return button == 2 ? this.handleFilterConfig() : super.func_231044_a_(x, y, button);
    }

    private boolean handleFilterConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || !(slot.func_75211_c().func_77973_b() instanceof ItemSmartFilter) || slot.field_75222_d < 0 || slot.field_75222_d >= 9) {
            return false;
        }
        int filterSlotIndex = slot.field_75222_d;
        ItemSmartFilter filter = (ItemSmartFilter)slot.func_75211_c().func_77973_b();
        if (this.routerPos != null) {
            MFLocator locator = MFLocator.filterInInstalledModule(this.routerPos, this.moduleSlotIndex, filterSlotIndex);
            if (filter.hasContainer()) {
                PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openFilterInInstalledModule(locator));
            } else {
                FilterGuiFactory.openFilterGui(locator);
            }
        } else if (this.hand != null) {
            MFLocator locator = MFLocator.filterInHeldModule(this.hand, filterSlotIndex);
            if (filter.hasContainer()) {
                PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openFilterInHeldModule(locator));
            } else {
                FilterGuiFactory.openFilterGui(locator);
            }
        }
        return true;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.sendDelay > 0) {
            this.sendToServer();
        }
    }

    Optional<TileEntityItemRouter> getItemRouter() {
        return this.routerPos != null ? TileEntityItemRouter.getRouterAt((IBlockReader)Minecraft.func_71410_x().field_71441_e, this.routerPos) : Optional.empty();
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (slotInd >= 9 && slotInd < 13) {
            this.augmentCounter.refresh(this.moduleItemStack);
            this.setupButtonVisibility();
        }
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    private int getFgColor(TintColor bg) {
        int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
        return luminance > 129 ? 0x404040 : 0xFFFFFF;
    }

    @Override
    public MouseOverHelp getMouseOverHelp() {
        return this.mouseOverHelp;
    }

    private class TerminationButton
    extends TexturedCyclerButton<ItemModule.Termination> {
        private final List<List<ITextComponent>> tooltips;

        public TerminationButton(int x, int y, ItemModule.Termination initialVal) {
            super(x, y, 16, 16, initialVal, GuiModule.this);
            this.tooltips = Lists.newArrayList();
            for (ItemModule.Termination termination : ItemModule.Termination.values()) {
                ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
                l.add((ITextComponent)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]));
                MiscUtil.appendMultilineText(l, TextFormatting.GRAY, termination.getTranslationKey(), new Object[0]);
                this.tooltips.add(l);
            }
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(((ItemModule.Termination)((Object)this.getState())).ordinal());
        }

        @Override
        protected int getTextureX() {
            switch ((ItemModule.Termination)((Object)this.getState())) {
                case NONE: {
                    return 128;
                }
                case NOT_RAN: {
                    return 224;
                }
                case RAN: {
                    return 144;
                }
            }
            throw new IllegalArgumentException("unknown value");
        }

        @Override
        protected int getTextureY() {
            return 32;
        }
    }

    private class MatchAllButton
    extends TexturedToggleButton {
        MatchAllButton(int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, GuiModule.this);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip.matchAll.false", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, TextFormatting.WHITE, "modularrouters.guiText.tooltip.matchAll.true", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 224 : 208;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class DirectionButton
    extends RadioButton {
        private static final int DIRECTION_GROUP = 1;
        private final ItemModule.RelativeDirection direction;

        DirectionButton(ItemModule.RelativeDirection dir, ItemModule module, int x, int y, boolean toggled) {
            super(1, x, y, 16, 16, toggled, GuiModule.this);
            this.direction = dir;
            StringTextComponent dirStr = new StringTextComponent(module.getDirectionString(dir));
            this.tooltip1.add(dirStr.func_240699_a_(TextFormatting.GRAY));
            this.tooltip2.add(dirStr.func_240699_a_(TextFormatting.YELLOW));
        }

        @Override
        protected int getTextureX() {
            return this.direction.ordinal() * 16 * 2 + (this.isToggled() ? 16 : 0);
        }

        @Override
        protected int getTextureY() {
            return 48;
        }

        public ItemModule.RelativeDirection getDirection() {
            return this.direction;
        }

        public void func_230930_b_() {
            for (ItemModule.RelativeDirection dir : ItemModule.RelativeDirection.values()) {
                DirectionButton db = GuiModule.this.getDirectionButton(dir);
                db.setToggled(false);
                if (db != this) continue;
                GuiModule.this.facing = db.getDirection();
            }
            super.func_230930_b_();
        }
    }

    private class ModuleToggleButton
    extends TexturedToggleButton {
        private final int flagId;

        ModuleToggleButton(ItemModule.ModuleFlags flag, int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, GuiModule.this);
            this.flagId = flag.ordinal();
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip." + (Object)((Object)ItemModule.ModuleFlags.values()[this.flagId]) + ".1", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, TextFormatting.WHITE, "modularrouters.guiText.tooltip." + (Object)((Object)ItemModule.ModuleFlags.values()[this.flagId]) + ".2", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.flagId * 16 * 2 + (this.isToggled() ? 16 : 0);
        }

        @Override
        protected int getTextureY() {
            return 32;
        }
    }

    private static class RegulatorTooltipButton
    extends TexturedButton {
        RegulatorTooltipButton(int x, int y, boolean isFluid) {
            super(x, y, 16, 16, p -> {});
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, isFluid ? "modularrouters.guiText.tooltip.fluidRegulatorTooltip" : "modularrouters.guiText.tooltip.regulatorTooltip", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return 112;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void func_230988_a_(SoundHandler soundHandlerIn) {
        }
    }
}

