/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiModuleDistributor
extends GuiModule {
    private static final ItemStack ROUTER_STACK = new ItemStack((IItemProvider)ModBlocks.ITEM_ROUTER.get());
    private StrategyButton sb;
    private DirectionButton db;

    public GuiModuleDistributor(ContainerModule container, PlayerInventory inv, ITextComponent displayText) {
        super(container, inv, displayText);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, this.moduleItemStack);
        this.func_230480_a_((Widget)new TooltipButton(this.field_147003_i + 127, this.field_147009_r + 23));
        this.sb = new StrategyButton(this.field_147003_i + 147, this.field_147009_r + 23, 16, 16, cdm.getDistributionStrategy());
        this.func_230480_a_((Widget)this.sb);
        this.db = new DirectionButton(this.field_147003_i + 147, this.field_147009_r + 43, cdm.isPulling());
        this.func_230480_a_((Widget)this.db);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 21, this.field_147003_i + 165, this.field_147009_r + 41, "modularrouters.guiText.popup.distributor.strategy");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 41, this.field_147003_i + 165, this.field_147009_r + 61, "modularrouters.guiText.popup.distributor.direction");
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT tag = super.buildMessageData();
        tag.func_74768_a("DistStrategy", ((CompiledDistributorModule.DistributionStrategy)((Object)this.sb.getState())).ordinal());
        tag.func_74757_a("Pulling", this.db.isToggled());
        return tag;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        GuiUtil.renderItemStack(matrixStack, this.field_230706_i_, ROUTER_STACK, this.field_147003_i + 127, this.field_147009_r + 43, "");
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y) {
            super(x, y, 16, 16, new ItemStack((IItemProvider)ModItems.DISTRIBUTOR_MODULE.get()), true, p -> {});
            this.tooltip1.add(ClientUtil.xlate("modularrouters.guiText.tooltip.distributor.strategy", new Object[0]));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void func_230988_a_(SoundHandler soundHandlerIn) {
        }

        @Override
        protected int getTextureX() {
            return 176;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class DirectionButton
    extends TexturedToggleButton {
        public DirectionButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, GuiModuleDistributor.this);
            MiscUtil.appendMultilineText(this.tooltip1, TextFormatting.WHITE, "modularrouters.itemText.fluid.direction.OUT", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, TextFormatting.WHITE, "modularrouters.itemText.fluid.direction.IN", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 160 : 176;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class StrategyButton
    extends TexturedCyclerButton<CompiledDistributorModule.DistributionStrategy> {
        private final List<List<ITextComponent>> tooltips;

        StrategyButton(int x, int y, int width, int height, CompiledDistributorModule.DistributionStrategy initialVal) {
            super(x, y, width, height, initialVal, GuiModuleDistributor.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledDistributorModule.DistributionStrategy strategy : CompiledDistributorModule.DistributionStrategy.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(strategy.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 32;
        }

        @Override
        public List<ITextComponent> getTooltip() {
            return this.tooltips.get(((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal());
        }
    }
}

