/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final Module module = new Module();
    public final Router router = new Router();

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Module");
        this.module.sender1BaseRange = builder.comment("Base range for Sender Mk1 (no range upgrades)").translation("modularrouters.gui.config.sender1BaseRange").defineInRange("sender1BaseRange", 8, 1, Integer.MAX_VALUE);
        this.module.sender1MaxRange = builder.comment("Max range for Sender Mk1").translation("modularrouters.gui.config.sender1MaxRange").defineInRange("sender1MaxRange", 16, 1, Integer.MAX_VALUE);
        this.module.sender2BaseRange = builder.comment("Base range for Sender Mk2 (no range upgrades)").translation("modularrouters.gui.config.sender2BaseRange").defineInRange("sender2BaseRange", 24, 1, Integer.MAX_VALUE);
        this.module.sender2MaxRange = builder.comment("Max range for Sender Mk2").translation("modularrouters.gui.config.sender2MaxRange").defineInRange("sender2MaxRange", 48, 1, Integer.MAX_VALUE);
        this.module.vacuumBaseRange = builder.comment("Base range for Vacuum (no range upgrades)").translation("modularrouters.gui.config.vacuumBaseRange").defineInRange("vacuumBaseRange", 6, 1, Integer.MAX_VALUE);
        this.module.vacuumMaxRange = builder.comment("Max range for Vacuum").translation("modularrouters.gui.config.vacuumMaxRange").defineInRange("vacuumMaxRange", 12, 1, Integer.MAX_VALUE);
        this.module.extruder1BaseRange = builder.comment("Base range for Extruder Mk1 (no range upgrades)").translation("gui.config.extruder1BaseRange").defineInRange("extruder1BaseRange", 16, 1, Integer.MAX_VALUE);
        this.module.extruder1MaxRange = builder.comment("Max range for Extruder Mk1").translation("gui.config.extruder1MaxRange").defineInRange("extruder1MaxRange", 32, 1, Integer.MAX_VALUE);
        this.module.extruder2BaseRange = builder.comment("Base range for Extruder Mk2 (no range upgrades)").translation("modularrouters.gui.config.extruder2BaseRange").defineInRange("extruder2BaseRange", 32, 1, Integer.MAX_VALUE);
        this.module.extruder2MaxRange = builder.comment("Max range for Extruder Mk2").translation("modularrouters.gui.config.extruder2MaxRange").defineInRange("extruder2MaxRange", 64, 1, Integer.MAX_VALUE);
        this.module.puller2BaseRange = builder.comment("Base range for Puller Mk2 (no range upgrades)").translation("modularrouters.gui.config.puller2BaseRange").defineInRange("puller2BaseRange", 12, 1, Integer.MAX_VALUE);
        this.module.puller2MaxRange = builder.comment("Max range for Puller Mk2").translation("modularrouters.gui.config.puller2MaxRange").defineInRange("puller2MaxRange", 24, 1, Integer.MAX_VALUE);
        this.module.fluid2BaseRange = builder.comment("Base range for Fluid Mk2 (no range upgrades)").translation("gui.config.fluid2BaseRange").defineInRange("fluid2BaseRange", 12, 1, Integer.MAX_VALUE);
        this.module.fluid2MaxRange = builder.comment("Max range for Fluid Mk2").translation("gui.config.fluid2MaxRange").defineInRange("fluid2MaxRange", 24, 1, Integer.MAX_VALUE);
        this.module.senderParticles = builder.comment("Should Sender modules show particle effects when working?").translation("modularrouters.gui.config.senderParticles").define("senderParticles", true);
        this.module.pullerParticles = builder.comment("Should Puller modules show particle effects when working?").translation("modularrouters.gui.config.pullerParticles").define("pullerParticles", true);
        this.module.placerParticles = builder.comment("Should Placer modules show particle effects when working?").translation("modularrouters.gui.config.placerParticles").define("placerParticles", true);
        this.module.breakerParticles = builder.comment("Should Breaker modules show particle effects when working?").translation("modularrouters.gui.config.breakerParticles").define("breakerParticles", true);
        this.module.vacuumParticles = builder.comment("Should Vacuum modules show particle effects when working?").translation("modularrouters.gui.config.vacuumParticles").define("vacuumParticles", true);
        this.module.flingerEffects = builder.comment("Should Flinger modules show smoke effects & play a sound when working?").translation("modularrouters.gui.config.flingerEffects").define("flingerEffects", true);
        this.module.extruderSound = builder.comment("Should Extruder Mk1/2 modules play a sound when placing/removing blocks?").translation("modularrouters.gui.config.extruderSound").define("extruderSound", true);
        this.module.extruderPushEntities = builder.comment("Should Extruder Mk1/2 modules push entities along when extruding blocks?").translation("modularrouters.gui.config.extruderPushEntities").define("extruderPushEntities", true);
        this.module.breakerHarvestLevelLimit = builder.comment("Should Breaker & Extruder Mk1 Modules respect the harvest level of the pickaxe used to craft them? (e.g. craft with an Iron Pickaxe => can't break Obsidian").translation("gui.config.breakerHarvestLevelLimit").define("breakerHarvestLevelLimit", true);
        this.module.activatorEntityBlacklist = builder.comment("List of entity types which the Activator Module (in entity mode) should never attempt to interact with. Any entity which opens a GUI when right-clicked, like Villagers, should be added here, especially if it prevents player interaction.").translation("gui.config.activatorEntityBlacklist").define("activatorEntityBlacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "minecraft:wandering_trader"}));
        builder.pop();
        builder.push("Router");
        this.router.baseTickRate = builder.comment("Base tick interval (in server ticks) for a router; router will run this often").translation("modularrouters.gui.config.baseTickRate").defineInRange("baseTickRate", 20, 1, Integer.MAX_VALUE);
        this.router.ticksPerUpgrade = builder.comment("Number of ticks by which 1 Speed Upgrade will reduce the router's tick interval").translation("modularrouters.gui.config.ticksPerUpgrade").defineInRange("ticksPerUpgrade", 2, 1, Integer.MAX_VALUE);
        this.router.hardMinTickRate = builder.comment("Hard minimum tick interval for a router regardless of Speed Upgrades").translation("gui.config.hardMinTickRate").defineInRange("hardMinTickRate", 2, 1, Integer.MAX_VALUE);
        this.router.ecoTimeout = builder.comment("Router with eco mode enabled will go into low-power mode if idle for this many server ticks").translation("modularrouters.gui.config.ecoTimeout").defineInRange("ecoTimeout", 100, 1, Integer.MAX_VALUE);
        this.router.lowPowerTickRate = builder.comment("Tick interval for an eco-mode router which has gone into low-power mode").translation("modularrouters.gui.config.lowPowerTickRate").defineInRange("lowPowerTickRate", 100, 1, Integer.MAX_VALUE);
        this.router.fluidBaseTransferRate = builder.comment("Base fluid transfer rate (mB/t in each direction) for a router").translation("gui.config.fluidBaseTransferRate").defineInRange("fluidBaseTransferRate", 50, 1, Integer.MAX_VALUE);
        this.router.fluidMaxTransferRate = builder.comment("Max fluid transfer rate (mB/t in each direction) for a router").translation("modularrouters.gui.config.baseTickRate").defineInRange("fluidMaxTransferRate", 400, 1, Integer.MAX_VALUE);
        this.router.mBperFluidUpgade = builder.comment("Fluid transfer rate increase per Fluid Transfer Upgrade").translation("gui.config.mBperFluidUpgade").defineInRange("mBperFluidUpgade", 10, 1, Integer.MAX_VALUE);
        builder.pop();
    }

    public static class Router {
        ForgeConfigSpec.IntValue baseTickRate;
        ForgeConfigSpec.IntValue ticksPerUpgrade;
        ForgeConfigSpec.IntValue hardMinTickRate;
        ForgeConfigSpec.IntValue ecoTimeout;
        ForgeConfigSpec.IntValue lowPowerTickRate;
        ForgeConfigSpec.IntValue fluidBaseTransferRate;
        ForgeConfigSpec.IntValue fluidMaxTransferRate;
        ForgeConfigSpec.IntValue mBperFluidUpgade;
    }

    public static class Module {
        ForgeConfigSpec.IntValue sender1BaseRange;
        ForgeConfigSpec.IntValue sender1MaxRange;
        ForgeConfigSpec.IntValue sender2BaseRange;
        ForgeConfigSpec.IntValue sender2MaxRange;
        ForgeConfigSpec.IntValue vacuumBaseRange;
        ForgeConfigSpec.IntValue vacuumMaxRange;
        ForgeConfigSpec.IntValue extruder1BaseRange;
        ForgeConfigSpec.IntValue extruder1MaxRange;
        ForgeConfigSpec.IntValue extruder2BaseRange;
        ForgeConfigSpec.IntValue extruder2MaxRange;
        ForgeConfigSpec.IntValue puller2BaseRange;
        ForgeConfigSpec.IntValue puller2MaxRange;
        ForgeConfigSpec.IntValue fluid2BaseRange;
        ForgeConfigSpec.IntValue fluid2MaxRange;
        ForgeConfigSpec.BooleanValue senderParticles;
        ForgeConfigSpec.BooleanValue pullerParticles;
        ForgeConfigSpec.BooleanValue placerParticles;
        ForgeConfigSpec.BooleanValue breakerParticles;
        ForgeConfigSpec.BooleanValue vacuumParticles;
        ForgeConfigSpec.BooleanValue flingerEffects;
        ForgeConfigSpec.BooleanValue extruderSound;
        ForgeConfigSpec.BooleanValue extruderPushEntities;
        ForgeConfigSpec.BooleanValue breakerHarvestLevelLimit;
        ForgeConfigSpec.ConfigValue<List<String>> activatorEntityBlacklist;
    }
}

