/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration;

import java.util.Arrays;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class XPCollection {
    private static final boolean[] AVAILABLE = new boolean[XPCollectionType.values().length];
    private static final ItemStack[] ICONS = new ItemStack[XPCollectionType.values().length];

    public static void detectXPTypes() {
        Arrays.fill(ICONS, null);
        for (XPCollectionType type : XPCollectionType.values()) {
            XPCollection.AVAILABLE[type.ordinal()] = !XPCollection.getIconForResource(type).func_190926_b();
        }
    }

    private static ItemStack getIconForResource(XPCollectionType type) {
        if (ICONS[type.ordinal()] == null) {
            if (type.isSolid()) {
                XPCollection.ICONS[type.ordinal()] = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(type.getRegistryName()));
            } else {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(type.getRegistryName());
                XPCollection.ICONS[type.ordinal()] = fluid == null || fluid == Fluids.field_204541_a ? ItemStack.field_190927_a : FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
            }
        }
        return ICONS[type.ordinal()];
    }

    public static enum XPCollectionType {
        SOLIDIFIED_EXPERIENCE(true, 8, "actuallyadditions:item_solidified_experience"),
        BOTTLE_O_ENCHANTING(true, 7, "minecraft:experience_bottle"),
        MEMORY_ESSENCE(false, 20, "pneumaticcraft:memory_essence"),
        CYCLIC_XP_JUICE(false, 20, "cyclic:xpjuice"),
        IF_ESSENCE(false, 20, "industrialforegoing:essence");

        private final boolean solid;
        private final int xpRatio;
        private final ResourceLocation registryName;

        private XPCollectionType(boolean solid, int xpRatio, String registryName) {
            this.solid = solid;
            this.xpRatio = xpRatio;
            this.registryName = new ResourceLocation(registryName);
        }

        public int getXpRatio() {
            return this.xpRatio;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public Fluid getFluid() {
            return (Fluid)ForgeRegistries.FLUIDS.getValue(this.registryName);
        }

        public String getModId() {
            return this.registryName.func_110624_b();
        }

        public boolean isAvailable() {
            return AVAILABLE[this.ordinal()];
        }

        public ItemStack getIcon() {
            return XPCollection.getIconForResource(this);
        }

        public ITextComponent getDisplayName() {
            return XPCollection.getIconForResource(this).func_200301_q();
        }
    }
}

