/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemBase
extends Item {
    public ItemBase(Item.Properties props) {
        super(props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (world == null) {
            return;
        }
        ITextComponent text = ClientSetup.keybindModuleInfo.func_238171_j_();
        if (ClientSetup.keybindModuleInfo.func_151470_d()) {
            this.addUsageInformation(stack, list);
        } else if (MRConfig.Client.Misc.alwaysShowModuleSettings || Screen.func_231173_s_()) {
            this.addExtraInformation(stack, list);
            if (ClientUtil.thisScreenPassesEvents()) {
                list.add((ITextComponent)ClientUtil.xlate("modularrouters.itemText.misc.holdKey", text.getString()));
            }
        } else if (!MRConfig.Client.Misc.alwaysShowModuleSettings && ClientUtil.thisScreenPassesEvents()) {
            list.add((ITextComponent)ClientUtil.xlate("modularrouters.itemText.misc.holdShiftKey", text.getString()));
        }
    }

    protected void addUsageInformation(ItemStack itemstack, List<ITextComponent> list) {
        MiscUtil.appendMultilineText(list, TextFormatting.GRAY, "modularrouters.itemText.usage.item." + itemstack.func_77973_b().getRegistryName().func_110623_a(), this.getExtraUsageParams());
    }

    protected abstract void addExtraInformation(ItemStack var1, List<ITextComponent> var2);

    protected Object[] getExtraUsageParams() {
        return new Object[0];
    }
}

