/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule1;
import me.desht.modularrouters.logic.filter.matchers.FluidMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidModule1
extends ItemModule {
    private static final TintColor TINT_COLOR = new TintColor(79, 191, 255);

    public FluidModule1() {
        super(ModItems.defaultProps(), CompiledFluidModule1::new);
    }

    @Override
    public String getRegulatorTranslationKey(ItemStack stack) {
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        boolean isAbsolute = compound.func_74767_n("RegulateAbsolute");
        return "modularrouters.guiText.tooltip.regulator." + (isAbsolute ? "labelFluidmB" : "labelFluidPct");
    }

    @Override
    public ContainerType<? extends ContainerModule> getContainerType() {
        return (ContainerType)ModContainerTypes.CONTAINER_MODULE_FLUID.get();
    }

    @Override
    protected ITextComponent getFilterItemDisplayName(ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getDisplayName).orElse(stack.func_200301_q());
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<ITextComponent> list) {
        super.addExtraInformation(stack, list);
        FluidModule1.addFluidModuleInformation(stack, list);
    }

    @Override
    public boolean isItemValidForFilter(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemSmartFilter) {
            return true;
        }
        if (stack.func_190916_E() > 1) {
            return false;
        }
        return FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> !fluidStack.isEmpty()).orElse(false);
    }

    @Override
    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new FluidMatcher(stack);
    }

    @Override
    public boolean isFluidModule() {
        return true;
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    static void addFluidModuleInformation(ItemStack stack, List<ITextComponent> list) {
        CompiledFluidModule1 cfm = new CompiledFluidModule1(null, stack);
        String dir = I18n.func_135052_a((String)("modularrouters.itemText.fluid.direction." + (Object)((Object)cfm.getFluidDirection())), (Object[])new Object[0]);
        list.add((ITextComponent)ClientUtil.xlate("modularrouters.itemText.fluid.direction", dir));
        list.add((ITextComponent)ClientUtil.xlate("modularrouters.itemText.fluid.maxTransfer", cfm.getMaxTransfer()));
    }

    public static enum FluidDirection {
        IN,
        OUT;


        public String getTranslationKey() {
            return "modularrouters.itemText.fluid.direction." + this.toString();
        }
    }
}

