/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModContainerTypes;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class VacuumModule
extends ItemModule
implements IRangedModule {
    private static final TintColor TINT_COLOR = new TintColor(120, 48, 191);

    public VacuumModule() {
        super(ModItems.defaultProps(), CompiledVacuumModule::new);
    }

    @Override
    public ContainerType<? extends ContainerModule> getContainerType() {
        return (ContainerType)ModContainerTypes.CONTAINER_MODULE_VACUUM.get();
    }

    @Override
    public void addSettingsInformation(ItemStack itemstack, List<ITextComponent> list) {
        super.addSettingsInformation(itemstack, list);
        CompiledVacuumModule cvm = new CompiledVacuumModule(null, itemstack);
        if (cvm.isXpMode()) {
            XPCollection.XPCollectionType type = cvm.getXPCollectionType();
            IFormattableTextComponent modName = new StringTextComponent(ModNameCache.getModName(type.getModId())).func_240699_a_(TextFormatting.BLUE);
            IFormattableTextComponent title = type.getDisplayName().func_230531_f_().func_240699_a_(TextFormatting.AQUA);
            list.add((ITextComponent)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum", new Object[0]).func_240702_b_(": ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)title).func_240702_b_(" - ").func_230529_a_((ITextComponent)modName));
            if (cvm.isAutoEjecting() && !type.isSolid()) {
                list.add(MiscUtil.settingsStr(TextFormatting.GREEN.toString(), (ITextComponent)ClientUtil.xlate("modularrouters.guiText.tooltip.xpVacuum.ejectFluid", new Object[0])));
            }
        }
    }

    @Override
    public int getBaseRange() {
        return MRConfig.Common.Module.vacuumBaseRange;
    }

    @Override
    public int getHardMaxRange() {
        return MRConfig.Common.Module.vacuumMaxRange;
    }

    @Override
    public boolean isOmniDirectional() {
        return true;
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }
}

