/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE_OLD = "ActionType";
    public static final String NBT_ACTION_TYPE = "ActionType2";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    public static final String NBT_ENTITY_MODE = "EntityMode";
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final EntityMode entityMode;
    private final boolean sneaking;
    private int entityIdx;
    private final Set<String> BLOCK_METHODS = ImmutableSet.of((Object)"onBlockActivated", (Object)"use");
    private final Set<String> ITEM_METHODS = ImmutableSet.of((Object)"onItemUseFirst", (Object)"onItemUse", (Object)"useOn", (Object)"onItemRightClick", (Object)"use");
    private static final Set<Item> itemBlacklist = new HashSet<Item>();
    private static final Set<Block> blockBlacklist = new HashSet<Block>();

    public CompiledActivatorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null) {
            this.actionType = compound.func_74764_b(NBT_ACTION_TYPE_OLD) ? ActionType.fromOldOrdinal(compound.func_74762_e(NBT_ACTION_TYPE_OLD)) : ActionType.values()[compound.func_74762_e(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.func_74762_e(NBT_LOOK_DIRECTION)];
            this.entityMode = EntityMode.values()[compound.func_74762_e(NBT_ENTITY_MODE)];
            this.sneaking = compound.func_74767_n(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ITEM_OR_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.entityMode = EntityMode.NEAREST;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        ItemStack stack = router.getBufferItemStack();
        if (itemBlacklist.contains(stack.func_77973_b())) {
            return false;
        }
        if (!stack.func_190926_b() && !this.getFilter().test(stack)) {
            return false;
        }
        World world = router.func_145831_w();
        BlockPos pos = router.func_174877_v();
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        Vector3d centre = Vector3d.func_237489_a_((Vector3i)pos);
        fakePlayer.func_70107_b(centre.func_82615_a() + (double)this.getFacing().func_82601_c() * 0.501, centre.func_82617_b() + (double)this.getFacing().func_96559_d() * 0.501, centre.func_82616_c() + (double)this.getFacing().func_82599_e() * 0.501);
        fakePlayer.func_226284_e_(this.sneaking);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        boolean didWork = false;
        if (this.actionType == ActionType.USE_ITEM_ON_ENTITY) {
            didWork = this.doUseItemOnEntity(router, fakePlayer);
        } else {
            fakePlayer.field_70177_z = MiscUtil.getYawFromFacing(this.getFacing());
            fakePlayer.field_70125_A = this.getFacing().func_176740_k() == Direction.Axis.Y ? (float)(this.getFacing().func_96559_d() * -90) : this.lookDirection.pitch;
            BlockRayTraceResult brtr = this.doRayTrace(pos, fakePlayer);
            BlockState state = world.func_180495_p(brtr.func_216350_a());
            if (brtr.func_216346_c() != RayTraceResult.Type.MISS && blockBlacklist.contains(state.func_177230_c())) {
                return false;
            }
            try {
                didWork = fakePlayer.field_71134_c.func_219441_a((ServerPlayerEntity)fakePlayer, world, stack, Hand.MAIN_HAND, brtr).func_226246_a_();
                if (!didWork) {
                    didWork = fakePlayer.field_71134_c.func_187250_a((ServerPlayerEntity)fakePlayer, world, stack, Hand.MAIN_HAND).func_226246_a_();
                }
            }
            catch (Exception e) {
                this.handleBlacklisting(stack, state, e);
            }
        }
        if (didWork) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            this.dropExtraItems(router, (PlayerEntity)fakePlayer);
        }
        return didWork;
    }

    private void handleBlacklisting(ItemStack stack, BlockState state, Exception e) {
        for (StackTraceElement el : e.getStackTrace()) {
            if (this.ITEM_METHODS.contains(el.getMethodName())) {
                ModularRouters.LOGGER.error("Attempting to use item {} threw an exception. Blacklisting this item for the Activator Module until next server restart!", (Object)stack);
                ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
                itemBlacklist.add(stack.func_77973_b());
                return;
            }
            if (!this.BLOCK_METHODS.contains(el.getMethodName())) continue;
            ModularRouters.LOGGER.error("Attempting to use block {} threw an exception. Blacklisting this block for the Activator Module until next server restart!", (Object)state);
            ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
            blockBlacklist.add(state.func_177230_c());
            return;
        }
    }

    private BlockRayTraceResult doRayTrace(BlockPos routerPos, FakePlayer fp) {
        Vector3d fpVec = fp.func_213303_ch();
        double reachDist = this.getPlayerReachDistance((PlayerEntity)fp);
        int i = 1;
        while ((double)i < reachDist) {
            VoxelShape shape;
            Vector3d targetVec;
            BlockRayTraceResult res;
            BlockPos targetPos = this.lookDirection.offset(routerPos.func_177967_a(this.getFacing(), i), i);
            if (!fp.field_70170_p.func_175623_d(targetPos) && (res = fp.field_70170_p.func_217299_a(new RayTraceContext(fpVec, targetVec = (shape = fp.field_70170_p.func_180495_p(targetPos).func_196954_c((IBlockReader)fp.field_70170_p, targetPos)).func_197766_b() ? Vector3d.func_237489_a_((Vector3i)targetPos) : ((AxisAlignedBB)shape.func_197756_d().get(0)).func_189972_c().func_178787_e(Vector3d.func_237491_b_((Vector3i)targetPos)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, null))).func_216346_c() == RayTraceResult.Type.BLOCK) {
                return res;
            }
            ++i;
        }
        return BlockRayTraceResult.func_216352_a((Vector3d)fpVec.func_178787_e(fp.func_70040_Z()), (Direction)this.getFacing().func_176734_d(), (BlockPos)routerPos.func_177972_a(this.getFacing()));
    }

    private double getPlayerReachDistance(PlayerEntity player) {
        ModifiableAttributeInstance attr;
        if (player != null && (attr = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            return attr.func_111126_e() + 1.0;
        }
        return 4.5;
    }

    private boolean doUseItemOnEntity(TileEntityItemRouter router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router);
        if (entity == null) {
            return false;
        }
        ActionResultType result = fakePlayer.func_190775_a(entity, Hand.MAIN_HAND);
        if (result.func_226246_a_()) {
            router.setBufferItemStack(fakePlayer.func_184614_ca());
            return true;
        }
        return false;
    }

    private Entity findEntity(TileEntityItemRouter router) {
        Direction face = this.getFacing();
        BlockPos pos = router.func_174877_v();
        AxisAlignedBB box = new AxisAlignedBB(pos.func_177972_a(face)).func_72321_a((double)(face.func_82601_c() * 3), (double)(face.func_96559_d() * 3), (double)(face.func_82599_e() * 3));
        List l = router.func_145831_w().func_175647_a(Entity.class, box, this::passesBlacklist);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.entityMode) {
            case RANDOM: {
                return (Entity)l.get(router.func_145831_w().field_73012_v.nextInt(l.size()));
            }
            case NEAREST: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                return (Entity)l.get(0);
            }
            case ROUND_ROBIN: {
                l.sort(Comparator.comparingDouble(o -> o.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (Entity)l.get(this.entityIdx);
            }
        }
        return null;
    }

    private boolean passesBlacklist(Entity e) {
        return !MRConfig.Common.Module.activatorEntityBlacklist.contains(e.func_200600_R().getRegistryName());
    }

    private void dropExtraItems(TileEntityItemRouter router, PlayerEntity fakePlayer) {
        NonNullList inv = fakePlayer.field_71071_by.field_70462_a;
        Vector3d where = Vector3d.func_237489_a_((Vector3i)router.func_174877_v().func_177972_a(this.getFacing()));
        for (int i = 1; i < inv.size() && !((ItemStack)inv.get(i)).func_190926_b(); ++i) {
            ItemEntity item = new ItemEntity(router.func_145831_w(), where.func_82615_a(), where.func_82617_b(), where.func_82616_c(), (ItemStack)inv.get(i));
            router.func_145831_w().func_217376_c((Entity)item);
            inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public static enum EntityMode {
        NEAREST,
        RANDOM,
        ROUND_ROBIN;


        public String getTranslationKey() {
            return "modularrouters.itemText.activator.entityMode." + this.toString();
        }
    }

    public static enum LookDirection {
        LEVEL(0.0f),
        ABOVE(-45.0f),
        BELOW(45.0f);

        private final float pitch;

        private LookDirection(float pitch) {
            this.pitch = pitch;
        }

        BlockPos offset(BlockPos pos, int dist) {
            switch (this) {
                case ABOVE: {
                    return pos.func_177967_a(Direction.UP, dist);
                }
                case BELOW: {
                    return pos.func_177967_a(Direction.DOWN, dist);
                }
            }
            return pos;
        }

        public String getTranslationKey() {
            return "modularrouters.itemText.activator.direction." + this.toString();
        }
    }

    public static enum ActionType {
        ITEM_OR_BLOCK,
        USE_ITEM_ON_ENTITY;


        public String getTranslationKey() {
            return "modularrouters.itemText.activator.action." + this.toString();
        }

        public static ActionType fromOldOrdinal(int ord) {
            return ord == 2 ? USE_ITEM_ON_ENTITY : ITEM_OR_BLOCK;
        }
    }
}

