/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.ItemBeamMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledSenderModule1
extends CompiledModule {
    public CompiledSenderModule1(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        PositionedItemHandler positionedItemHandler;
        IItemHandler buffer = router.getBuffer();
        ItemStack bufferStack = buffer.getStackInSlot(0);
        if (this.getFilter().test(bufferStack) && (positionedItemHandler = this.findTargetInventory(router)).isValid()) {
            int sent;
            int nToSend = this.getItemsPerTick(router);
            if (this.getRegulationAmount() > 0) {
                int existing = InventoryUtils.countItems(bufferStack, positionedItemHandler.handler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreDamage());
                if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                    return false;
                }
            }
            if ((sent = InventoryUtils.transferItems(buffer, positionedItemHandler.handler, 0, nToSend)) > 0) {
                if (MRConfig.Common.Module.senderParticles) {
                    this.playParticles(router, positionedItemHandler.pos, ItemHandlerHelper.copyStackWithSize((ItemStack)bufferStack, (int)sent));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    void playParticles(TileEntityItemRouter router, BlockPos targetPos, ItemStack stack) {
        if (router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2) {
            PacketHandler.NETWORK.send(PacketDistributor.TRACKING_CHUNK.with(() -> router.func_145831_w().func_175726_f(router.func_174877_v())), (Object)new ItemBeamMessage(router, targetPos, false, stack, this.getBeamColor(), router.getTickRate(), false));
        }
    }

    protected int getBeamColor() {
        return 0xFFC000;
    }

    PositionedItemHandler findTargetInventory(TileEntityItemRouter router) {
        ModuleTarget target = this.getEffectiveTarget(router);
        if (target != null) {
            return target.getItemHandler().map(h -> new PositionedItemHandler(target.gPos.func_218180_b(), (IItemHandler)h)).orElse(PositionedItemHandler.INVALID);
        }
        return PositionedItemHandler.INVALID;
    }

    @Override
    public ModuleTarget getEffectiveTarget(TileEntityItemRouter router) {
        BlockPos p0 = this.getTarget().gPos.func_218180_b();
        BlockPos.Mutable pos = new BlockPos.Mutable(p0.func_177958_n(), p0.func_177956_o(), p0.func_177952_p());
        Direction face = this.getTarget().face;
        World world = router.func_145831_w();
        for (int i = 1; i <= this.getRange(); ++i) {
            TileEntity te = world.func_175625_s((BlockPos)pos);
            if (te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getTarget().face).isPresent()) {
                GlobalPos gPos = MiscUtil.makeGlobalPos(world, pos.func_185334_h());
                return new ModuleTarget(gPos, face, BlockUtil.getBlockName(world, (BlockPos)pos));
            }
            if (!this.isPassable(world, (BlockPos)pos, face)) {
                return null;
            }
            pos.func_189536_c(this.getFacing());
        }
        return null;
    }

    private boolean isPassable(World w, BlockPos pos, Direction face) {
        BlockState state = w.func_180495_p(pos);
        return !MiscUtil.blockHasSolidSide(state, (IBlockReader)w, pos, face.func_176734_d()) || !state.func_200015_d((IBlockReader)w, pos);
    }

    static class PositionedItemHandler {
        private final BlockPos pos;
        private final IItemHandler handler;
        static final PositionedItemHandler INVALID = new PositionedItemHandler(null, null);

        PositionedItemHandler(BlockPos pos, IItemHandler handler) {
            this.pos = pos;
            this.handler = handler;
        }

        boolean isValid() {
            return this.pos != null && this.handler != null;
        }
    }
}

