/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;

public class InspectionMatcher
implements IItemMatcher {
    private final ComparisonList comparisonList;

    public InspectionMatcher(ComparisonList comparisons) {
        this.comparisonList = comparisons;
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        int matched = 0;
        if (this.comparisonList.items.isEmpty()) {
            return false;
        }
        for (Comparison comp : this.comparisonList.items) {
            if (!comp.matches(stack)) continue;
            if (!this.comparisonList.matchAll) {
                return true;
            }
            ++matched;
        }
        return matched >= this.comparisonList.items.size();
    }

    public static enum InspectionOp {
        NONE,
        GT,
        LT,
        LE,
        GE,
        EQ,
        NE;


        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionOp." + this.toString();
        }

        public boolean check(long value, long target) {
            switch (this) {
                case NONE: {
                    return false;
                }
                case GT: {
                    return value > target;
                }
                case LT: {
                    return value < target;
                }
                case LE: {
                    return value <= target;
                }
                case GE: {
                    return value >= target;
                }
                case EQ: {
                    return value == target;
                }
                case NE: {
                    return value != target;
                }
            }
            return false;
        }

        public InspectionOp cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionOp.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionOp.values().length - 1;
            }
            return InspectionOp.values()[n];
        }
    }

    public static enum InspectionSubject {
        NONE,
        DURABILITY,
        FLUID,
        ENERGY,
        ENCHANT,
        FOOD;

        private static final BigDecimal HUNDRED;

        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionSubject." + this.toString();
        }

        private Optional<Integer> getValue(ItemStack stack) {
            switch (this) {
                case NONE: {
                    return Optional.empty();
                }
                case DURABILITY: {
                    return stack.func_77958_k() > 0 ? Optional.of(this.asPercentage(stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k())) : Optional.empty();
                }
                case FLUID: {
                    return this.getFluidPercent(stack);
                }
                case ENERGY: {
                    return this.getEnergyPercent(stack);
                }
                case ENCHANT: {
                    return this.getHighestEnchantLevel(stack);
                }
                case FOOD: {
                    return this.getFoodValue(stack);
                }
            }
            throw new IllegalArgumentException("invalid comparison subject! " + (Object)((Object)this));
        }

        private Optional<Integer> getFoodValue(ItemStack stack) {
            if (stack.func_77973_b().func_219971_r()) {
                return Optional.of(stack.func_77973_b().func_219967_s().func_221466_a());
            }
            return Optional.empty();
        }

        private Optional<Integer> getHighestEnchantLevel(ItemStack stack) {
            return EnchantmentHelper.func_82781_a((ItemStack)stack).values().stream().max(Comparator.naturalOrder());
        }

        private Optional<Integer> getEnergyPercent(ItemStack stack) {
            return stack.getCapability(CapabilityEnergy.ENERGY, null).map(handler -> Optional.of(this.asPercentage(handler.getEnergyStored(), handler.getMaxEnergyStored()))).orElse(Optional.empty());
        }

        private Optional<Integer> getFluidPercent(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                int total = 0;
                int max = 0;
                for (int idx = 0; idx < handler.getTanks(); ++idx) {
                    max += handler.getTankCapacity(idx);
                    total += handler.getFluidInTank(idx).getAmount();
                }
                return Optional.of(this.asPercentage(total, max));
            }).orElse(Optional.empty());
        }

        public String getDisplaySuffix() {
            switch (this) {
                case NONE: 
                case ENCHANT: 
                case FOOD: {
                    return "";
                }
            }
            return "%";
        }

        public InspectionSubject cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionSubject.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionSubject.values().length - 1;
            }
            return InspectionSubject.values()[n];
        }

        private int asPercentage(long val, long max) {
            if (max == 0L) {
                return 0;
            }
            BigDecimal a = new BigDecimal(val);
            BigDecimal b = new BigDecimal(max);
            return a.multiply(HUNDRED).divide(b, 1).intValue();
        }

        static {
            HUNDRED = new BigDecimal(100);
        }
    }

    public static class Comparison {
        static final Comparison BAD_COMPARISON = new Comparison();
        private final InspectionSubject subject;
        private final InspectionOp op;
        private final long target;

        Comparison(InspectionSubject subject, InspectionOp op, int target) {
            this.subject = subject;
            this.op = op;
            this.target = target;
        }

        Comparison() {
            this.subject = null;
            this.op = null;
            this.target = 0L;
        }

        boolean matches(ItemStack stack) {
            if (this.op == null || this.subject == null) {
                return false;
            }
            Optional val = this.subject.getValue(stack);
            return this.op.check(val.orElse(0).intValue(), this.target);
        }

        public static Comparison fromString(String s) {
            String[] fields = s.split(" ", 3);
            if (fields.length != 3) {
                return BAD_COMPARISON;
            }
            try {
                InspectionSubject subject = InspectionSubject.valueOf(fields[0]);
                InspectionOp op = InspectionOp.valueOf(fields[1]);
                int target = Integer.parseInt(fields[2]);
                return new Comparison(subject, op, target);
            }
            catch (IllegalArgumentException e) {
                return BAD_COMPARISON;
            }
        }

        public String toString() {
            return Joiner.on((String)" ").join((Object)this.subject, (Object)this.op, new Object[]{this.target});
        }

        @OnlyIn(value=Dist.CLIENT)
        public String asLocalizedText() {
            if (this.subject == null || this.op == null) {
                return "<?>";
            }
            return Joiner.on((String)" ").join((Object)I18n.func_135052_a((String)("modularrouters.guiText.label.inspectionSubject." + (Object)((Object)this.subject)), (Object[])new Object[0]), (Object)I18n.func_135052_a((String)("modularrouters.guiText.label.inspectionOp." + (Object)((Object)this.op)), (Object[])new Object[0]), new Object[]{this.target + this.subject.getDisplaySuffix()});
        }
    }

    public static class ComparisonList {
        public final List<Comparison> items;
        boolean matchAll;

        public ComparisonList(List<Comparison> items, boolean matchAll) {
            this.items = items;
            this.matchAll = matchAll;
        }

        public void setMatchAll(boolean matchAll) {
            this.matchAll = matchAll;
        }

        public boolean isMatchAll() {
            return this.matchAll;
        }
    }
}

