/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class ModuleSettingsMessage {
    private final MFLocator locator;
    private final CompoundNBT payload;

    ModuleSettingsMessage(PacketBuffer buf) {
        this.locator = MFLocator.fromBuffer(buf);
        this.payload = buf.func_150793_b();
    }

    public ModuleSettingsMessage(MFLocator locator, CompoundNBT payload) {
        this.locator = locator;
        this.payload = payload;
    }

    public void toBytes(PacketBuffer buf) {
        this.locator.writeBuf(buf);
        buf.func_150786_a(this.payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ItemStack moduleStack = this.locator.getModuleStack((PlayerEntity)player);
                if (moduleStack.func_77973_b() instanceof ItemModule) {
                    CompoundNBT compound = ModuleHelper.validateNBT(moduleStack);
                    for (String key : this.payload.func_150296_c()) {
                        compound.func_218657_a(key, this.payload.func_74781_a(key));
                    }
                    if (this.locator.routerPos != null) {
                        TileEntityItemRouter.getRouterAt((IBlockReader)player.func_130014_f_(), this.locator.routerPos).ifPresent(router -> router.recompileNeeded(1));
                    }
                } else {
                    ModularRouters.LOGGER.warn("ignoring ModuleSettingsMessage for " + player.func_145748_c_().getString() + " - expected module not found @ " + this.locator.toString());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

