/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncUpgradeSettingsMessage {
    private final int tunedValue;
    private final Hand hand;

    public SyncUpgradeSettingsMessage(int tunedValue, Hand hand) {
        this.tunedValue = tunedValue;
        this.hand = hand;
    }

    public SyncUpgradeSettingsMessage(PacketBuffer buf) {
        this.tunedValue = buf.readInt();
        this.hand = buf.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.tunedValue);
        buf.writeBoolean(this.hand == Hand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack held;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (held = player.func_184586_b(this.hand)).func_77973_b() instanceof SyncUpgrade) {
                SyncUpgrade.setTunedValue(held, this.tunedValue);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

