/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morebows.item;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.mcreator.morebows.MorebowsModElements;
import net.mcreator.morebows.item.BowUpgradeItem;
import net.mcreator.morebows.itemgroup.MoreBowsItemGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@MorebowsModElements.ModElement.Tag
public class AdvancedBowItem
extends MorebowsModElements.ModElement {
    @ObjectHolder(value="morebows:advanced_bow")
    public static final Item block = null;
    @ObjectHolder(value="morebows:entitybulletadvanced_bow")
    public static final EntityType arrow = null;

    public AdvancedBowItem(MorebowsModElements instance) {
        super(instance, 4);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemRanged());
        this.elements.entities.add(() -> (EntityType)EntityType.Builder.func_220322_a(ArrowCustomEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).setCustomClientFactory(ArrowCustomEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("entitybulletadvanced_bow").setRegistryName("entitybulletadvanced_bow"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init(FMLCommonSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)arrow, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
    }

    @SubscribeEvent
    public void zoom(FOVUpdateEvent event) {
        if (event.getEntity().func_184607_cu() != null) {
            Item thisBow = new ItemStack((IItemProvider)block, 1).func_77973_b();
            if (event.getEntity().func_184607_cu().func_77973_b() == thisBow) {
                PlayerEntity entity = event.getEntity();
                ItemStack stack = entity.func_184607_cu();
                ItemRanged item = (ItemRanged)entity.func_184607_cu().func_77973_b();
                float mult = item.getZoom(event.getEntity());
                event.setNewfov(event.getFov() * mult);
            }
        }
    }

    public static ArrowEntity customArrow(final World worldIn, LivingEntity shooter, final int antigrav, int venom, int debilitate, final float explode, final boolean pickup) {
        ArrowEntity arr = new ArrowEntity(worldIn, shooter){
            int count;
            int resetCount;
            {
                super(x0, x1);
                this.count = 0;
                this.resetCount = antigrav;
            }

            protected void func_184549_a(RayTraceResult raytraceResultIn) {
                super.func_184549_a(raytraceResultIn);
                if (!worldIn.field_72995_K && explode > 0.0f) {
                    this.field_70170_p.func_217385_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), explode, Explosion.Mode.NONE);
                }
            }

            protected void func_184548_a(LivingEntity living) {
                living.field_70172_ad = 0;
                super.func_184548_a(living);
                living.field_70172_ad = 0;
            }

            public void func_70071_h_() {
                super.func_70071_h_();
                ++this.count;
                if (this.resetCount == 0) {
                    this.count = 0;
                    this.func_189654_d(false);
                } else if (this.count == this.resetCount) {
                    this.count = 0;
                    this.func_189654_d(false);
                } else {
                    this.func_189654_d(true);
                }
            }

            protected ItemStack func_184550_j() {
                if (pickup) {
                    return new ItemStack((IItemProvider)Items.field_151032_g);
                }
                return ItemStack.field_190927_a;
            }

            protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
                Entity entity = p_213868_1_.func_216348_a();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.field_70172_ad = 0;
                }
                super.func_213868_a(p_213868_1_);
            }
        };
        int effectTime = 240;
        if (venom > -1) {
            EffectInstance poison = new EffectInstance(Effects.field_76436_u, effectTime, venom);
            EffectInstance wither = new EffectInstance(Effects.field_82731_v, effectTime, venom);
            arr.func_184558_a(poison);
            arr.func_184558_a(wither);
        }
        if (debilitate > -1) {
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, effectTime, debilitate);
            EffectInstance weakness = new EffectInstance(Effects.field_76437_t, effectTime, debilitate);
            arr.func_184558_a(slowness);
            arr.func_184558_a(weakness);
        }
        return arr;
    }

    public static ArrowItem customArrowItem(final int antigrav, final int venom, final int debilitate, final float explode, final boolean pickup) {
        return new ArrowItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j)){

            public AbstractArrowEntity func_200887_a(World worldIn, ItemStack stack, LivingEntity shooter) {
                return AdvancedBowItem.customArrow(worldIn, shooter, antigrav, venom, debilitate, explode, pickup);
            }
        };
    }

    public static ArrowCustomEntity shoot(World world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        ArrowCustomEntity entityarrow = new ArrowCustomEntity((EntityType<? extends ArrowCustomEntity>)arrow, entity, world);
        entityarrow.func_70186_c(entity.func_70040_Z().field_72450_a, entity.func_70040_Z().field_72448_b, entity.func_70040_Z().field_72449_c, power * 2.0f, 0.0f);
        entityarrow.func_174810_b(true);
        entityarrow.func_70243_d(true);
        entityarrow.func_70239_b(damage);
        entityarrow.func_70240_a(knockback);
        world.func_217376_c((Entity)entityarrow);
        int x = (int)entity.func_226277_ct_();
        int y = (int)entity.func_226278_cu_();
        int z = (int)entity.func_226281_cx_();
        world.func_184148_a((PlayerEntity)null, (double)x, (double)y, (double)z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundCategory.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static ArrowCustomEntity shoot(LivingEntity entity, LivingEntity target) {
        ArrowCustomEntity entityarrow = new ArrowCustomEntity((EntityType<? extends ArrowCustomEntity>)arrow, entity, entity.field_70170_p);
        double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - 1.1;
        double d1 = target.func_226277_ct_() - entity.func_226277_ct_();
        double d3 = target.func_226281_cx_() - entity.func_226281_cx_();
        entityarrow.func_70186_c(d1, d0 - entityarrow.func_226278_cu_() + (double)MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * (double)0.2f, d3, 1.6f, 12.0f);
        entityarrow.func_174810_b(true);
        entityarrow.func_70243_d(true);
        entity.field_70170_p.func_217376_c((Entity)entityarrow);
        int x = (int)entity.func_226277_ct_();
        int y = (int)entity.func_226278_cu_();
        int z = (int)entity.func_226281_cx_();
        entity.field_70170_p.func_184148_a((PlayerEntity)null, (double)x, (double)y, (double)z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundCategory.PLAYERS, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }

    @OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
    public static class ArrowCustomEntity
    extends AbstractArrowEntity
    implements IRendersAsItem {
        public ArrowCustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            super(arrow, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, World world) {
            super(type, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, double x, double y, double z, World world) {
            super(type, x, y, z, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, LivingEntity entity, World world) {
            super(type, entity, world);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_184543_l() {
            return new ItemStack((IItemProvider)Items.field_151032_g, 1);
        }

        protected ItemStack func_184550_j() {
            return new ItemStack((IItemProvider)Items.field_151032_g, 1);
        }

        protected void func_184548_a(LivingEntity entity) {
            super.func_184548_a(entity);
            entity.func_85034_r(entity.func_85035_bI() - 1);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            int x = (int)this.func_226277_ct_();
            int y = (int)this.func_226278_cu_();
            int z = (int)this.func_226281_cx_();
            World world = this.field_70170_p;
            Entity entity = this.func_212360_k();
            if (this.field_70254_i) {
                this.func_70106_y();
            }
        }
    }

    public static class ItemRanged
    extends BowItem {
        static float maxUpgrades = 10.0f;
        final float[][][][] multishotPitchYaw = new float[][][][]{new float[][][]{new float[][]{{0.0f, 0.0f}}}, new float[][][]{new float[][]{{0.4f, 0.0f}, {-0.4f, 0.0f}}, new float[][]{{0.0f, 0.4f}, {0.0f, -0.4f}}}, new float[][][]{new float[][]{{0.4f, 0.0f}, {-0.4f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 0.4f}, {0.0f, -0.4f}, {0.0f, 0.0f}}, new float[][]{{0.4325f, 0.25f}, {0.4325f, -0.25f}, {-0.4325f, 0.0f}}}, new float[][][]{new float[][]{{0.4325f, 0.25f}, {0.4325f, -0.25f}, {-0.4325f, 0.0f}, {0.0f, 0.0f}}}};
        private static HashMap<String, Float> defaultValues;
        public static String[] modifiers;

        public ItemRanged() {
            super(new Item.Properties().func_200916_a(MoreBowsItemGroup.tab).func_200918_c(1536));
            this.setRegistryName("advanced_bow");
            defaultValues = new HashMap();
            defaultValues.put("total_tier", Float.valueOf(0.0f));
            defaultValues.put("arrow_speed", Float.valueOf(1.0f));
            defaultValues.put("draw_speed", Float.valueOf(20.0f));
            defaultValues.put("base_damage", Float.valueOf(3.0f));
            defaultValues.put("inaccuracy", Float.valueOf(1.0f));
            defaultValues.put("piercing", Float.valueOf(0.0f));
            defaultValues.put("antigravity", Float.valueOf(0.0f));
            defaultValues.put("venom", Float.valueOf(-1.0f));
            defaultValues.put("debilitate", Float.valueOf(-1.0f));
            defaultValues.put("multishot", Float.valueOf(1.0f));
            defaultValues.put("explosive", Float.valueOf(0.0f));
            for (String modifier : modifiers) {
                defaultValues.put(modifier + "_tier", Float.valueOf(0.0f));
            }
            this.func_185043_a(new ResourceLocation("pull"), (stack, world, living) -> {
                if (living == null) {
                    return 0.0f;
                }
                float chargeSpeed = ItemRanged.getFloat(stack, "draw_speed");
                float maxArrowVel = ItemRanged.getFloat(stack, "arrow_speed");
                float pull = !(living.func_184607_cu().func_77973_b() instanceof BowItem) ? 0.0f : (float)(stack.func_77988_m() - living.func_184605_cv()) / chargeSpeed;
                if ((pull = maxArrowVel * (pull * pull + pull * 2.0f) / 3.0f) > maxArrowVel) {
                    pull = maxArrowVel;
                }
                return pull /= maxArrowVel;
            });
            this.func_185043_a(new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        }

        private String infoFromModifier(ItemStack stack, String modifier) {
            String key = modifier + "_tier";
            int tier = (int)ItemRanged.getFloat(stack, key);
            if (tier == 0) {
                return "";
            }
            BowUpgradeItem.ItemCustom upgrade = BowUpgradeItem.getUpgrade(modifier, tier);
            if (upgrade == null) {
                return "";
            }
            return upgrade.toString();
        }

        public void func_77624_a(ItemStack itemstack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            String usedUpgrades = "Upgrades " + (int)ItemRanged.getFloat(itemstack, "total_tier") + "/" + (int)maxUpgrades;
            list.add((ITextComponent)new StringTextComponent("\u00a7a" + usedUpgrades));
            String colorCode = "\u00a79";
            for (String modifier : modifiers) {
                String info = this.infoFromModifier(itemstack, modifier);
                if (info.length() == 0) continue;
                list.add((ITextComponent)new StringTextComponent(colorCode + info));
            }
        }

        public UseAction func_77661_b(ItemStack stack) {
            return UseAction.BOW;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 72000;
        }

        public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
            if (entityLiving instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityLiving;
                boolean flag = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
                ItemStack itemstack = playerentity.func_213356_f(stack);
                int i = this.func_77626_a(stack) - timeLeft;
                if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)playerentity, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                    return;
                }
                if (!itemstack.func_190926_b() || flag) {
                    if (itemstack.func_190926_b()) {
                        itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                    }
                    float f = ItemRanged.getCurrentArrowVelocity(stack, i);
                    float chargeSpeed = ItemRanged.getFloat(stack, "draw_speed");
                    float maxArrowVel = ItemRanged.getFloat(stack, "arrow_speed");
                    float inaccuracy = ItemRanged.getFloat(stack, "inaccuracy");
                    float baseDamage = ItemRanged.getFloat(stack, "base_damage");
                    byte piercing = (byte)ItemRanged.getFloat(stack, "piercing");
                    int antigrav = (int)ItemRanged.getFloat(stack, "antigravity");
                    int numArrows = (int)ItemRanged.getFloat(stack, "multishot");
                    int venom = (int)ItemRanged.getFloat(stack, "venom");
                    int debilitate = (int)ItemRanged.getFloat(stack, "debilitate");
                    float explode = ItemRanged.getFloat(stack, "explosive");
                    if (!((double)f < 0.1)) {
                        boolean flag1;
                        boolean bl = flag1 = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
                        if (!worldIn.field_72995_K) {
                            int mode = 2;
                            float[][][] modeList = this.multishotPitchYaw[numArrows - 1];
                            float[][] angleDeltas = modeList[mode %= modeList.length];
                            for (int arr = 0; arr < numArrows; ++arr) {
                                int k;
                                int j;
                                ArrowItem testArrow;
                                ArrowItem arrowitem = testArrow = AdvancedBowItem.customArrowItem(antigrav, venom, debilitate, explode, arr == 0);
                                AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, itemstack, (LivingEntity)playerentity);
                                abstractarrowentity = this.customeArrow(abstractarrowentity);
                                float pitch = playerentity.field_70125_A + angleDeltas[arr][0];
                                float yaw = playerentity.field_70177_z + angleDeltas[arr][1];
                                abstractarrowentity.func_184547_a((Entity)playerentity, pitch, yaw, 0.0f, f * 3.0f, inaccuracy);
                                abstractarrowentity.func_70239_b((double)(baseDamage * f / maxArrowVel));
                                abstractarrowentity.func_213872_b(piercing);
                                if (f == maxArrowVel) {
                                    abstractarrowentity.func_70243_d(true);
                                }
                                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                                    abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                                }
                                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                                    abstractarrowentity.func_70240_a(k);
                                }
                                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                                    abstractarrowentity.func_70015_d(100);
                                }
                                stack.func_222118_a(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
                                if (flag1 || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                                    abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                                }
                                worldIn.func_217376_c((Entity)abstractarrowentity);
                            }
                        }
                        worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                        if (!flag1 && !playerentity.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                playerentity.field_71071_by.func_184437_d(itemstack);
                            }
                        }
                        playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    }
                }
            }
        }

        public float getZoom(PlayerEntity entity) {
            ItemStack stack = entity.func_184586_b(entity.func_184600_cs());
            float chargeSpeed = ItemRanged.getFloat(stack, "draw_speed");
            float maxArrowVel = ItemRanged.getFloat(stack, "arrow_speed");
            float pull = MathHelper.func_76131_a((float)(this.func_77626_a(null) - entity.func_184605_cv()), (float)0.0f, (float)chargeSpeed);
            float maxZoom = 150.0f;
            return 1.0f - pull / maxZoom;
        }

        public static float getCurrentArrowVelocity(ItemStack stack, int charge) {
            float chargeSpeed = ItemRanged.getFloat(stack, "draw_speed");
            float maxArrowVel = ItemRanged.getFloat(stack, "arrow_speed");
            float f = (float)charge / chargeSpeed;
            if ((f = maxArrowVel * (f * f + f * 2.0f) / 3.0f) > maxArrowVel) {
                f = maxArrowVel;
            }
            return f;
        }

        public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
            ItemStack itemstack;
            boolean flag = !playerIn.func_213356_f(itemstack = playerIn.func_184586_b(handIn)).func_190926_b();
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (PlayerEntity)playerIn, (Hand)handIn, (boolean)flag);
            if (ret != null) {
                return ret;
            }
            if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }

        public Predicate<ItemStack> func_220004_b() {
            return field_220007_a;
        }

        public AbstractArrowEntity customeArrow(AbstractArrowEntity arrow) {
            return arrow;
        }

        public static float getFloat(ItemStack stack, String key) {
            if (stack.func_196082_o().func_74764_b(key)) {
                return stack.func_77978_p().func_74760_g(key);
            }
            float defaultValue = defaultValues.get(key).floatValue();
            stack.func_196082_o().func_74776_a(key, defaultValue);
            return defaultValue;
        }

        public static void setFloat(ItemStack stack, String key, float val) {
            stack.func_196082_o().func_74776_a(key, val);
        }

        public static ItemStack applyUpgrade(ItemStack bow, ItemStack upgrade) {
            if (!(bow.func_77973_b() instanceof ItemRanged)) {
                return ItemStack.field_190927_a;
            }
            if (!(upgrade.func_77973_b() instanceof BowUpgradeItem.ItemCustom)) {
                return ItemStack.field_190927_a;
            }
            BowUpgradeItem.ItemCustom upgradeItem = (BowUpgradeItem.ItemCustom)upgrade.func_77973_b();
            int op = upgradeItem.op;
            String key = upgradeItem.modifier;
            if (key.equals("none")) {
                return ItemStack.field_190927_a;
            }
            float amount = upgradeItem.amount;
            float tier = upgradeItem.tier;
            float bowStat = ItemRanged.getFloat(bow, key);
            float bowStatTier = ItemRanged.getFloat(bow, key + "_tier");
            float bowTier = ItemRanged.getFloat(bow, "total_tier");
            if (bowTier >= maxUpgrades) {
                return ItemStack.field_190927_a;
            }
            if (tier != bowStatTier + 1.0f) {
                return ItemStack.field_190927_a;
            }
            if (op == 0) {
                float newBowStat = amount + bowStat;
                float newTier = tier;
                ItemStack newBow = bow.func_77946_l();
                ItemRanged.setFloat(newBow, key, newBowStat);
                ItemRanged.setFloat(newBow, key + "_tier", newTier);
                ItemRanged.setFloat(newBow, "total_tier", bowTier + 1.0f);
                return newBow;
            }
            return ItemStack.field_190927_a;
        }

        static {
            modifiers = new String[]{"arrow_speed", "draw_speed", "base_damage", "inaccuracy", "piercing", "antigravity", "venom", "debilitate", "multishot", "explosive"};
        }
    }
}

